/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.meta.model.display;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mule.api.annotation.NoImplement;

@NoImplement
public class PathModel {
    private final Type type;
    private final List<String> fileExtensions;
    private final boolean acceptsUrls;
    private final Location location;

    public PathModel(Type type, boolean acceptsUrls, Location location, String[] fileExtensions) {
        this.type = type;
        this.acceptsUrls = acceptsUrls;
        this.location = location;
        this.fileExtensions = Collections.unmodifiableList(Arrays.asList(fileExtensions));
    }

    public List<String> getFileExtensions() {
        return this.type == Type.DIRECTORY ? Collections.emptyList() : this.fileExtensions;
    }

    public Type getType() {
        return this.type;
    }

    public boolean acceptsUrls() {
        return this.acceptsUrls;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PathModel)) {
            return false;
        }
        PathModel that = (PathModel)obj;
        return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.fileExtensions, that.fileExtensions) && Objects.equals(this.acceptsUrls, that.acceptsUrls) && Objects.equals((Object)this.location, (Object)that.location);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.fileExtensions, this.acceptsUrls, this.location});
    }

    public static enum Type {
        DIRECTORY,
        FILE,
        ANY;

    }

    public static enum Location {
        EMBEDDED,
        EXTERNAL,
        ANY;

    }
}

