/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.objectbuilder;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.function.Predicate;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.module.extension.api.loader.java.type.FieldElement;
import org.mule.runtime.module.extension.api.runtime.privileged.EventedExecutionContext;
import org.mule.runtime.module.extension.api.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ParameterGroupObjectBuilder<T>
extends DefaultObjectBuilder<T> {
    private final ParameterGroupDescriptor groupDescriptor;
    private static final Cache<Class<?>, List<FieldElement>> fieldsCache = CacheBuilder.newBuilder().weakKeys().build();

    public ParameterGroupObjectBuilder(ParameterGroupDescriptor groupDescriptor) {
        super(groupDescriptor.getType().getDeclaringClass().get());
        this.groupDescriptor = groupDescriptor;
    }

    public T build(EventedExecutionContext executionContext) throws MuleException {
        return this.doBuild(arg_0 -> ((EventedExecutionContext)executionContext).hasParameter(arg_0), arg_0 -> ((EventedExecutionContext)executionContext).getParameter(arg_0), ValueResolvingContext.from(executionContext.getEvent(), executionContext.getConfiguration()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T build(ResolverSetResult result) throws MuleException {
        Map<String, Object> resultMap = result.asMap();
        CoreEvent initialiserEvent = null;
        try {
            initialiserEvent = MuleExtensionUtils.getInitialiserEvent();
            T t = this.doBuild(resultMap::containsKey, resultMap::get, ValueResolvingContext.from(initialiserEvent));
            return t;
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
    }

    private T doBuild(Predicate<String> hasParameter, Function<String, Object> parameters, ValueResolvingContext context) throws MuleException {
        try {
            ((List)fieldsCache.get(this.groupDescriptor.getType().getDeclaringClass().get(), () -> this.groupDescriptor.getType().getFields())).forEach(field -> {
                String name = field.getName();
                if (hasParameter.test(name)) {
                    this.addPropertyResolver(name, new StaticValueResolver(parameters.apply(name)));
                }
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            throw new DefaultMuleException(e.getCause());
        }
        return this.build(context);
    }
}

