/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.service.scheduler.ThreadType;
import org.mule.service.scheduler.internal.NullScheduledFuture;
import org.mule.service.scheduler.internal.QuartzCronJob;
import org.mule.service.scheduler.internal.QuartzScheduledFututre;
import org.mule.service.scheduler.internal.RunnableFutureDecorator;
import org.mule.service.scheduler.internal.RunnableRepeatableFutureDecorator;
import org.mule.service.scheduler.internal.ScheduledFutureDecorator;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScheduler
extends AbstractExecutorService
implements org.mule.runtime.api.scheduler.Scheduler {
    private static final long FORCEFUL_SHUTDOWN_TIMEOUT_SECS = 5L;
    private static final Logger logger = LoggerFactory.getLogger(DefaultScheduler.class);
    private final AtomicInteger idGenerator = new AtomicInteger(0);
    private final String name;
    private final ExecutorService executor;
    private final ScheduledExecutorService scheduledExecutor;
    private final Scheduler quartzScheduler;
    private final ThreadType threadType;
    private Class<? extends QuartzCronJob> jobClass = QuartzCronJob.class;
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private static final ScheduledFuture<?> NULL_SCHEDULED_FUTURE = NullScheduledFuture.INSTANCE;
    private Map<RunnableFuture<?>, ScheduledFuture<?>> scheduledTasks;
    private volatile boolean shutdown = false;
    private final Supplier<Long> shutdownTimeoutMillis;
    private final Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback;

    public DefaultScheduler(String name, ExecutorService executor, int parallelTasksEstimate, ScheduledExecutorService scheduledExecutor, Scheduler quartzScheduler, ThreadType threadsType, Supplier<Long> shutdownTimeoutMillis, Consumer<org.mule.runtime.api.scheduler.Scheduler> shutdownCallback) {
        this.name = name + " @" + Integer.toHexString(this.hashCode());
        this.scheduledTasks = new ConcurrentHashMap(parallelTasksEstimate, 1.0f, Runtime.getRuntime().availableProcessors());
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        this.quartzScheduler = quartzScheduler;
        this.threadType = threadsType;
        this.shutdownTimeoutMillis = shutdownTimeoutMillis;
        this.shutdownCallback = shutdownCallback;
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        this.checkShutdown();
        Objects.requireNonNull(command);
        return this.doSchedule(this.newTaskFor(command, null), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        this.checkShutdown();
        Objects.requireNonNull(callable);
        return this.doSchedule(this.newTaskFor(callable), delay, unit);
    }

    private <V> ScheduledFuture<V> doSchedule(RunnableFuture<V> task, long delay, TimeUnit unit) {
        ScheduledFutureDecorator scheduled = new ScheduledFutureDecorator(this.scheduledExecutor.schedule(this.schedulableTask(task), delay, unit), task, false);
        this.putTask(task, scheduled);
        return scheduled;
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        this.checkShutdown();
        Objects.requireNonNull(command);
        RunnableRepeatableFutureDecorator task = new RunnableRepeatableFutureDecorator(() -> super.newTaskFor(command, null), t -> {
            if (t.isCancelled()) {
                this.taskFinished((RunnableFuture<?>)t);
            }
        }, Thread.currentThread().getContextClassLoader(), this, command.getClass().getName(), this.idGenerator.getAndIncrement());
        ScheduledFutureDecorator scheduled = new ScheduledFutureDecorator(this.scheduledExecutor.scheduleAtFixedRate(this.schedulableTask(task), initialDelay, period, unit), task, true);
        this.putTask(task, scheduled);
        return scheduled;
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        this.checkShutdown();
        Objects.requireNonNull(command);
        RunnableRepeatableFutureDecorator task = new RunnableRepeatableFutureDecorator(() -> super.newTaskFor(command, null), t -> this.fixedDelayWrapUp((RunnableFuture<?>)t, delay, unit), Thread.currentThread().getContextClassLoader(), this, command.getClass().getName(), this.idGenerator.getAndIncrement());
        ScheduledFutureDecorator scheduled = new ScheduledFutureDecorator(this.scheduledExecutor.schedule(this.reschedulableTask(task, delay, unit), initialDelay, unit), task, true);
        this.putTask(task, scheduled);
        return scheduled;
    }

    private <T> Runnable reschedulableTask(RunnableFuture<T> task, long delay, TimeUnit unit) {
        return () -> {
            block2: {
                try {
                    this.executor.execute(task);
                }
                catch (RejectedExecutionException e) {
                    if (this.executor.isShutdown()) break block2;
                    logger.warn(e.getClass().getName() + " scheduling next execution of task " + task.toString() + ". Message was: " + e.getMessage());
                    this.fixedDelayWrapUp(task, delay, unit);
                }
            }
        };
    }

    private void fixedDelayWrapUp(RunnableFuture<?> task, long delay, TimeUnit unit) {
        if (!task.isCancelled()) {
            this.scheduledExecutor.schedule(this.reschedulableTask(task, delay, unit), delay, unit);
        } else {
            this.taskFinished(task);
        }
    }

    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression) {
        return this.scheduleWithCronExpression(command, cronExpression, TimeZone.getDefault());
    }

    public ScheduledFuture<?> scheduleWithCronExpression(Runnable command, String cronExpression, TimeZone timeZone) {
        this.checkShutdown();
        Objects.requireNonNull(command);
        RunnableRepeatableFutureDecorator task = new RunnableRepeatableFutureDecorator(() -> super.newTaskFor(command, null), t -> {
            if (t.isCancelled()) {
                this.taskFinished((RunnableFuture<?>)t);
            }
        }, Thread.currentThread().getContextClassLoader(), this, command.getClass().getName(), this.idGenerator.getAndIncrement());
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put(QuartzCronJob.JOB_TASK_KEY, (Object)this.schedulableTask(task));
        JobDetail job = JobBuilder.newJob(this.jobClass).usingJobData(jobDataMap).build();
        CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression).withMisfireHandlingInstructionIgnoreMisfires().inTimeZone(timeZone)).build();
        try {
            this.quartzScheduler.scheduleJob(job, (Trigger)trigger);
        }
        catch (SchedulerException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        QuartzScheduledFututre scheduled = new QuartzScheduledFututre(this.quartzScheduler, (Trigger)trigger, task);
        this.putTask(task, scheduled);
        return scheduled;
    }

    private <T> Runnable schedulableTask(RunnableFuture<T> task) {
        return () -> this.executor.execute(task);
    }

    public void setJobClass(Class<? extends QuartzCronJob> jobClass) {
        this.jobClass = jobClass;
    }

    @Override
    public void shutdown() {
        logger.debug("Shutting down " + this.toString());
        this.shutdown = true;
        for (Map.Entry<RunnableFuture<?>, ScheduledFuture<?>> taskEntry : this.scheduledTasks.entrySet()) {
            ScheduledFuture<?> scheduledFuture = taskEntry.getValue();
            if (scheduledFuture instanceof ScheduledFutureDecorator && !((ScheduledFutureDecorator)scheduledFuture).isPeriodic()) continue;
            scheduledFuture.cancel(false);
        }
        this.shutdownCallback.accept(this);
        this.tryTerminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        logger.debug("Shutting down NOW " + this.toString());
        this.shutdown = true;
        try {
            ArrayList tasks = new ArrayList(this.scheduledTasks.size());
            for (Map.Entry<RunnableFuture<?>, ScheduledFuture<?>> taskEntry : this.scheduledTasks.entrySet()) {
                taskEntry.getValue().cancel(true);
                taskEntry.getKey().cancel(true);
                if (!(taskEntry.getKey() instanceof RunnableFutureDecorator) || ((RunnableFutureDecorator)taskEntry.getKey()).isStarted()) continue;
                tasks.add(taskEntry.getKey());
            }
            this.scheduledTasks.clear();
            ArrayList<RunnableFuture<?>> arrayList = tasks;
            return arrayList;
        }
        finally {
            this.shutdownCallback.accept(this);
            this.tryTerminate();
        }
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown || this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown && this.scheduledTasks.isEmpty();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long stopNanos = System.nanoTime() + unit.toNanos(timeout);
        while (System.nanoTime() <= stopNanos) {
            if (this.isTerminated()) {
                return true;
            }
            if (!this.terminationLatch.await(50L, TimeUnit.MILLISECONDS)) continue;
            return true;
        }
        return this.isTerminated();
    }

    public void stop() {
        this.shutdown();
        try {
            Long timeout = this.shutdownTimeoutMillis.get();
            if (!this.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                List<Runnable> cancelledJobs = this.shutdownNow();
                if (!this.awaitTermination(5L, TimeUnit.SECONDS)) {
                    logger.warn("Scheduler " + this.toString() + " did not shutdown gracefully after " + timeout + " " + TimeUnit.MILLISECONDS.toString() + ".");
                } else if (!cancelledJobs.isEmpty()) {
                    logger.warn("Scheduler " + this.toString() + " terminated.");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("The jobs " + cancelledJobs + " were cancelled.");
                } else {
                    logger.info(cancelledJobs.size() + " jobs were cancelled.");
                }
            }
        }
        catch (InterruptedException ie) {
            this.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return this.newDecoratedTaskFor(super.newTaskFor(callable), callable.getClass());
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return this.newDecoratedTaskFor(super.newTaskFor(runnable, value), runnable.getClass());
    }

    private <T> RunnableFuture<T> newDecoratedTaskFor(RunnableFuture<T> newTaskFor, Class<?> taskClass) {
        return new RunnableFutureDecorator<T>(newTaskFor, Thread.currentThread().getContextClassLoader(), this, taskClass.getName(), this.idGenerator.getAndIncrement());
    }

    @Override
    public void execute(Runnable command) {
        this.checkShutdown();
        RunnableFuture<Object> runnableFutureCommand = command instanceof RunnableFuture ? (RunnableFuture<Object>)command : this.newTaskFor(command, null);
        this.putTask(runnableFutureCommand, NULL_SCHEDULED_FUTURE);
        try {
            this.executor.execute(runnableFutureCommand);
        }
        catch (Exception e) {
            this.removeTask(runnableFutureCommand);
            throw e;
        }
    }

    protected void checkShutdown() {
        if (this.isShutdown()) {
            throw new RejectedExecutionException(this.toString() + " already shutdown");
        }
    }

    protected void taskFinished(RunnableFuture<?> task) {
        this.removeTask(task);
        this.tryTerminate();
    }

    protected void putTask(RunnableFuture<?> task, ScheduledFuture<?> scheduledFuture) {
        this.scheduledTasks.put(task, scheduledFuture);
    }

    protected void removeTask(RunnableFuture<?> task) {
        this.scheduledTasks.remove(task);
    }

    private void tryTerminate() {
        if (this.isTerminated()) {
            this.terminationLatch.countDown();
        }
    }

    public ThreadType getThreadType() {
        return this.threadType;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return (Object)((Object)this.getThreadType()) + " - " + this.getName() + "{" + System.lineSeparator() + "  executor: " + this.executor.toString() + System.lineSeparator() + "  shutdown: " + this.shutdown + System.lineSeparator() + "}";
    }
}

