/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.iterator.StreamingIterator;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.internal.util.message.ResultToMessageIterator;
import org.mule.runtime.core.internal.util.message.ResultToMessageStreamingIterator;
import org.mule.runtime.core.internal.util.message.ResultsToMessageList;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class MessageUtils {
    private MessageUtils() {
    }

    public static Message toMessage(Result result) {
        return MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY));
    }

    public static Message toMessage(Result result, MediaType mediaType) {
        return MessageUtils.toMessage(result, mediaType, (CursorProviderFactory)null, null);
    }

    public static Message toMessage(Result result, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        return MessageUtils.toMessage(result, result.getMediaType().orElse(MediaType.ANY), cursorProviderFactory, event);
    }

    public static Message toMessage(Result<?, ?> result, MediaType mediaType, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        Object value = StreamingUtils.streamingContent(result.getOutput(), cursorProviderFactory, event);
        return MessageUtils.toMessage(result, mediaType, DataType.fromObject((Object)value), value);
    }

    public static Message toMessage(Result<?, ?> result, MediaType mediaType, CursorProviderFactory cursorProviderFactory, CoreEvent event, DataType dataType) {
        Object value = StreamingUtils.streamingContent(result.getOutput(), cursorProviderFactory, event);
        return MessageUtils.toMessage(result, mediaType, dataType, value);
    }

    public static List<Message> toMessageCollection(Collection<Result> results, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        if (!(results instanceof List)) {
            results = new ArrayList<Result>(results);
        }
        return new ResultsToMessageList((List)results, cursorProviderFactory, event);
    }

    public static Iterator<Message> toMessageIterator(Iterator<Result> results, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        if (results instanceof StreamingIterator) {
            return new ResultToMessageStreamingIterator((StreamingIterator)results, cursorProviderFactory, event);
        }
        return new ResultToMessageIterator(results, cursorProviderFactory, event);
    }

    private static Message toMessage(Result<?, ?> result, MediaType mediaType, DataType dataType, Object value) {
        Message.Builder builder = Message.builder().payload(new TypedValue(value, DataType.builder((DataType)dataType).mediaType(mediaType).build(), result.getLength()));
        result.getAttributes().ifPresent(arg_0 -> ((Message.Builder)builder).attributesValue(arg_0));
        result.getAttributesMediaType().ifPresent(arg_0 -> ((Message.Builder)builder).attributesMediaType(arg_0));
        return builder.build();
    }
}

