/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class MessageProcessors {
    private MessageProcessors() {
    }

    public static MessageProcessorChain newChain(Optional<ProcessingStrategy> processingStrategy, List<Processor> processors) {
        if (processors.size() == 1 && processors.get(0) instanceof MessageProcessorChain) {
            return (MessageProcessorChain)processors.get(0);
        }
        DefaultMessageProcessorChainBuilder defaultMessageProcessorChainBuilder = new DefaultMessageProcessorChainBuilder();
        processingStrategy.ifPresent(x$0 -> defaultMessageProcessorChainBuilder.setProcessingStrategy((ProcessingStrategy)x$0));
        return defaultMessageProcessorChainBuilder.chain(processors).build();
    }

    public static MessageProcessorChain newChain(Optional<ProcessingStrategy> processingStrategy, Processor ... processors) {
        return MessageProcessors.newChain(processingStrategy, Arrays.asList(processors));
    }

    public static CoreEvent processToApply(CoreEvent event, ReactiveProcessor processor) throws MuleException {
        return MessageProcessors.processToApply(event, processor, false);
    }

    public static CoreEvent processToApply(CoreEvent event, ReactiveProcessor processor, boolean completeContext) throws MuleException {
        try {
            return (CoreEvent)Mono.just((Object)event).transform((Function)processor).switchIfEmpty(Mono.from(((BaseEventContext)event.getContext()).getResponsePublisher())).doOnSuccess(MessageProcessors.completeSuccessIfNeeded(event.getContext(), completeContext)).doOnError(MessageProcessors.completeErrorIfNeeded(event.getContext(), completeContext)).block();
        }
        catch (Throwable e) {
            throw Exceptions.rxExceptionToMuleException(e);
        }
    }

    public static CoreEvent processToApplyWithChildContext(CoreEvent event, ReactiveProcessor processor) throws MuleException {
        try {
            return (CoreEvent)Mono.just((Object)event).transform(publisher -> Mono.from((Publisher)publisher).flatMap(request -> Mono.from(MessageProcessors.internalProcessWithChildContext(request, processor, MessageProcessors.newChildContext(event, Optional.empty()), false)))).block();
        }
        catch (Throwable e) {
            throw Exceptions.rxExceptionToMuleException(e);
        }
    }

    public static Publisher<CoreEvent> process(CoreEvent event, ReactiveProcessor processor) {
        return Mono.just((Object)event).transform((Function)processor).onErrorMap(t -> !(t instanceof MessagingException), t -> {
            if (processor instanceof Component) {
                return new MessagingException(event, (Throwable)t, (Component)processor);
            }
            return new MessagingException(event, (Throwable)t);
        }).switchIfEmpty(Mono.from(((BaseEventContext)event.getContext()).getResponsePublisher())).doOnSuccess(MessageProcessors.completeSuccessIfNeeded(event.getContext(), true)).doOnError(MessageProcessors.completeErrorIfNeeded(event.getContext(), true));
    }

    public static Publisher<CoreEvent> processWithChildContext(CoreEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation) {
        return MessageProcessors.internalProcessWithChildContext(event, processor, MessageProcessors.newChildContext(event, componentLocation), true);
    }

    public static BaseEventContext newChildContext(CoreEvent event, Optional<ComponentLocation> componentLocation) {
        return DefaultEventContext.child((BaseEventContext)event.getContext(), componentLocation);
    }

    public static Publisher<CoreEvent> processWithChildContext(CoreEvent event, ReactiveProcessor processor, BaseEventContext childContext) {
        return MessageProcessors.internalProcessWithChildContext(event, processor, childContext, true);
    }

    public static Publisher<CoreEvent> processWithChildContext(CoreEvent event, ReactiveProcessor processor, Optional<ComponentLocation> componentLocation, FlowExceptionHandler exceptionHandler) {
        return MessageProcessors.internalProcessWithChildContext(event, processor, DefaultEventContext.child((BaseEventContext)event.getContext(), componentLocation, exceptionHandler), true);
    }

    private static Publisher<CoreEvent> internalProcessWithChildContext(CoreEvent event, ReactiveProcessor processor, EventContext child, boolean completeParentOnEmpty) {
        return Mono.just((Object)CoreEvent.builder(child, event).build()).transform((Function)processor).doOnNext(MessageProcessors.completeSuccessIfNeeded(child, true)).switchIfEmpty(Mono.from(((BaseEventContext)child).getResponsePublisher())).map(result -> CoreEvent.builder(event.getContext(), result).build()).doOnError(MessagingException.class, me -> me.setProcessedEvent(CoreEvent.builder(event.getContext(), me.getEvent()).build())).doOnSuccess(result -> {
            if (result == null && completeParentOnEmpty) {
                ((BaseEventContext)event.getContext()).success();
            }
        });
    }

    private static Consumer<CoreEvent> completeSuccessIfNeeded(EventContext child, boolean complete) {
        return result -> {
            if (!((BaseEventContext)child).isComplete() && complete) {
                ((BaseEventContext)child).success((CoreEvent)result);
            }
        };
    }

    private static Consumer<Throwable> completeErrorIfNeeded(EventContext child, boolean complete) {
        return throwable -> {
            if (!((BaseEventContext)child).isComplete() && complete) {
                ((BaseEventContext)child).error((Throwable)throwable);
            }
        };
    }

    public static Optional<ProcessingStrategy> getProcessingStrategy(ConfigurationComponentLocator locator, Location rootContainerLocation) {
        return locator.find(rootContainerLocation).filter(loc -> loc instanceof FlowConstruct).map(loc -> ((FlowConstruct)loc).getProcessingStrategy());
    }

    public static Publisher<CoreEvent> transform(Publisher<CoreEvent> publisher, ReactiveProcessor processor) {
        return Flux.from(publisher).transform((Function)processor);
    }

    public static Publisher<CoreEvent> flatMap(Publisher<CoreEvent> publisher, Function<CoreEvent, Publisher<CoreEvent>> function, Component component) {
        return Flux.from(publisher).flatMap(event -> Mono.from((Publisher)((Publisher)function.apply((CoreEvent)event))).onErrorMap(e -> !(e instanceof MessagingException), e -> new MessagingException((CoreEvent)event, (Throwable)e, component)));
    }
}

