/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.routing;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.routing.RouterResultsHandler;

public class DefaultRouterResultsHandler
implements RouterResultsHandler {
    private boolean returnCollectionWithSingleResult = false;

    public DefaultRouterResultsHandler() {
    }

    public DefaultRouterResultsHandler(boolean returnCollectionWithSingleResult) {
        this.returnCollectionWithSingleResult = returnCollectionWithSingleResult;
    }

    @Override
    public CoreEvent aggregateResults(List<CoreEvent> results, CoreEvent previous) {
        if (results == null) {
            return null;
        }
        if (results.size() == 1) {
            PrivilegedEvent event = (PrivilegedEvent)results.get(0);
            if (event == null) {
                return event;
            }
            if (event != null && event.getMessage() != null) {
                if (this.returnCollectionWithSingleResult) {
                    return this.createMessageCollectionWithSingleMessage(event);
                }
                return event;
            }
            return previous;
        }
        List<CoreEvent> nonNullResults = results.stream().filter(object -> object != null && object.getMessage() != null).collect(Collectors.toList());
        if (nonNullResults.size() == 0) {
            return CoreEvent.builder(previous).message(Message.of(null)).build();
        }
        if (nonNullResults.size() == 1) {
            return (CoreEvent)nonNullResults.get(0);
        }
        return this.createMessageCollection(nonNullResults, previous);
    }

    private CoreEvent createMessageCollectionWithSingleMessage(PrivilegedEvent event) {
        Message coll = Message.builder().collectionValue(Collections.singletonList(event.getMessage()), Message.class).build();
        event = PrivilegedEvent.builder(event).message(coll).build();
        PrivilegedEvent.setCurrentEvent(event);
        return event;
    }

    private CoreEvent createMessageCollection(List<CoreEvent> nonNullResults, CoreEvent previous) {
        PrivilegedEvent.Builder resultBuilder = PrivilegedEvent.builder(previous);
        ArrayList<Message> list = new ArrayList<Message>();
        for (CoreEvent event : nonNullResults) {
            for (String flowVarName : event.getVariables().keySet()) {
                resultBuilder.addVariable(flowVarName, ((TypedValue)event.getVariables().get(flowVarName)).getValue(), ((TypedValue)event.getVariables().get(flowVarName)).getDataType());
            }
            list.add(event.getMessage());
        }
        Message coll = Message.builder().collectionValue(list, Message.class).build();
        PrivilegedEvent resultEvent = resultBuilder.message(coll).build();
        PrivilegedEvent.setCurrentEvent(resultEvent);
        return resultEvent;
    }
}

