/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.HasOutputModel;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.MediaTypeUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.api.util.SystemUtils;
import org.mule.runtime.core.internal.util.message.MessageUtils;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.loader.java.property.MediaTypeModelProperty;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.CollectionReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.MapReturnHandler;
import org.mule.runtime.module.extension.internal.runtime.operation.resulthandler.ReturnHandler;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

abstract class AbstractReturnDelegate
implements ReturnDelegate {
    protected final MuleContext muleContext;
    private boolean returnsListOfMessages = false;
    private final CursorProviderFactory cursorProviderFactory;
    private final MediaType defaultMediaType;
    private boolean isSpecialHandling = false;
    private ReturnHandler returnHandler = ReturnHandler.nullHandler();

    protected AbstractReturnDelegate(ComponentModel componentModel, CursorProviderFactory cursorProviderFactory, MuleContext muleContext) {
        if (componentModel instanceof HasOutputModel) {
            HasOutputModel hasOutputModel = (HasOutputModel)componentModel;
            this.returnsListOfMessages = MuleExtensionUtils.returnsListOfMessages((HasOutputModel)hasOutputModel);
            MetadataType outputType = hasOutputModel.getOutput().getType();
            if (ExtensionMetadataTypeUtils.isMap((MetadataType)outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new MapReturnHandler(hasOutputModel);
            } else if (ExtensionMetadataTypeUtils.isJavaCollection((MetadataType)outputType)) {
                this.isSpecialHandling = true;
                this.returnHandler = new CollectionReturnHandler(outputType);
            }
        }
        this.muleContext = muleContext;
        this.cursorProviderFactory = cursorProviderFactory;
        this.defaultMediaType = componentModel.getModelProperty(MediaTypeModelProperty.class).map(MediaTypeModelProperty::getMediaType).orElseGet(() -> {
            if (componentModel instanceof HasOutputModel) {
                MetadataType output = ((HasOutputModel)componentModel).getOutput().getType();
                return MetadataFormat.JAVA.equals((Object)output.getMetadataFormat()) && output instanceof ObjectType ? MediaType.APPLICATION_JAVA : MediaType.ANY;
            }
            return MediaType.ANY;
        });
    }

    protected Message toMessage(Object value, ExecutionContextAdapter operationContext) {
        MediaType mediaType = this.resolveMediaType(value, (ExecutionContextAdapter<ComponentModel>)operationContext);
        CoreEvent event = operationContext.getEvent();
        if (value instanceof Result) {
            Result resultValue = (Result)value;
            return this.isSpecialHandling && this.returnHandler.handles(resultValue.getOutput()) ? MessageUtils.toMessage((Result)((Result)value), (MediaType)mediaType, (CursorProviderFactory)this.cursorProviderFactory, (CoreEvent)event, (DataType)this.returnHandler.getDataType()) : MessageUtils.toMessage((Result)((Result)value), (MediaType)mediaType, (CursorProviderFactory)this.cursorProviderFactory, (CoreEvent)event);
        }
        if (value instanceof Collection && this.returnsListOfMessages) {
            value = MessageUtils.toMessageCollection((Collection)((Collection)value), (CursorProviderFactory)this.cursorProviderFactory, (CoreEvent)event);
        } else if (value instanceof Iterator && this.returnsListOfMessages) {
            value = MessageUtils.toMessageIterator((Iterator)((Iterator)value), (CursorProviderFactory)this.cursorProviderFactory, (CoreEvent)event);
        }
        value = StreamingUtils.streamingContent((Object)value, (CursorProviderFactory)this.cursorProviderFactory, (CoreEvent)event);
        Object messageBuilder = this.returnsListOfMessages && value instanceof Collection ? Message.builder().collectionValue((Collection)value, Message.class) : (this.isSpecialHandling && this.returnHandler.handles(value) ? this.returnHandler.toMessageBuilder(value) : Message.builder().value(value));
        return messageBuilder.mediaType(mediaType).build();
    }

    protected MediaType resolveMediaType(Object value, ExecutionContextAdapter<ComponentModel> operationContext) {
        Optional optionalMediaType;
        Charset existingEncoding = SystemUtils.getDefaultEncoding((MuleContext)this.muleContext);
        MediaType mediaType = this.defaultMediaType;
        if (value instanceof Result && (optionalMediaType = ((Result)value).getMediaType()).isPresent() && (mediaType = (MediaType)optionalMediaType.get()).getCharset().isPresent()) {
            existingEncoding = mediaType.getCharset().get();
        }
        if (mediaType == null) {
            mediaType = MediaType.ANY;
        }
        if (operationContext.hasParameter("outputMimeType")) {
            mediaType = MediaType.parseDefinedInApp((String)operationContext.getParameter("outputMimeType"));
        }
        mediaType = operationContext.hasParameter("outputEncoding") ? mediaType.withCharset(MediaTypeUtils.parseCharset((String)((String)operationContext.getParameter("outputEncoding")))) : mediaType.withCharset(existingEncoding);
        return mediaType;
    }
}

