/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.streaming.bytes.factory;

import java.io.InputStream;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.streaming.CursorProvider;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;

@NoExtend
public abstract class AbstractCursorStreamProviderFactory
extends AbstractComponent
implements CursorStreamProviderFactory {
    private final ByteBufferManager bufferManager;
    protected final StreamingManager streamingManager;

    protected AbstractCursorStreamProviderFactory(ByteBufferManager bufferManager, StreamingManager streamingManager) {
        this.bufferManager = bufferManager;
        this.streamingManager = streamingManager;
    }

    @Override
    public final Object of(CoreEvent event, InputStream inputStream) {
        if (inputStream instanceof CursorStream) {
            return this.streamingManager.manage(((CursorStream)inputStream).getProvider(), event);
        }
        Object value = this.resolve(inputStream, event);
        if (value instanceof CursorStreamProvider) {
            value = this.streamingManager.manage((CursorProvider)((CursorStreamProvider)value), event);
        }
        return value;
    }

    protected ByteBufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected abstract Object resolve(InputStream var1, CoreEvent var2);
}

