/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.expression;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.AbstractMessageTransformer;
import org.mule.runtime.core.internal.transformer.expression.ExpressionArgument;

public abstract class AbstractExpressionTransformer
extends AbstractMessageTransformer {
    protected List<ExpressionArgument> arguments;

    public AbstractExpressionTransformer() {
        this.registerSourceType(DataType.OBJECT);
        this.setReturnDataType(DataType.OBJECT);
        this.arguments = new ArrayList<ExpressionArgument>(4);
    }

    public void addArgument(ExpressionArgument argument) {
        this.arguments.add(argument);
    }

    public boolean removeArgument(ExpressionArgument argument) {
        return this.arguments.remove((Object)argument);
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.arguments == null || this.arguments.size() == 0) {
            throw new InitialisationException(CoreMessages.objectIsNull("arguments[]"), (Initialisable)this);
        }
        for (ExpressionArgument argument : this.arguments) {
            argument.setMuleContext(this.muleContext);
            argument.setExpressionEvaluationClassLoader(Thread.currentThread().getContextClassLoader());
            try {
                argument.validate();
            }
            catch (Exception e) {
                throw new InitialisationException((Throwable)e, (Initialisable)this);
            }
        }
    }

    public List<ExpressionArgument> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<ExpressionArgument> arguments) {
        this.arguments = arguments;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getArguments());
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && this.getArguments().equals(((AbstractExpressionTransformer)obj).getArguments());
    }
}

