/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.privileged.component.AbstractExecutableComponent;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeProcessorChainRouter
extends AbstractExecutableComponent
implements Lifecycle {
    private static Logger LOGGER = LoggerFactory.getLogger(CompositeProcessorChainRouter.class);
    private List<MessageProcessorChain> processorChains = Collections.emptyList();

    public void setProcessorChains(List<MessageProcessorChain> processorChains) {
        this.processorChains = processorChains;
    }

    @Override
    protected ReactiveProcessor getExecutableFunction() {
        return publisher -> Mono.from((Publisher)publisher).flatMapMany(initial -> Flux.fromIterable(this.processorChains).reduce(initial, this.processChain()));
    }

    private BiFunction<CoreEvent, MessageProcessorChain, CoreEvent> processChain() {
        return (event, processorChain) -> {
            Latch completionLatch = new Latch();
            BaseEventContext childContext = DefaultEventContext.child((BaseEventContext)event.getContext(), Optional.ofNullable(this.getLocation()));
            childContext.onComplete((response, throwable) -> completionLatch.countDown());
            CoreEvent result = (CoreEvent)Mono.from(MessageProcessors.processWithChildContext(event, (ReactiveProcessor)processorChain, childContext)).block();
            try {
                completionLatch.await();
            }
            catch (InterruptedException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Thread interrupted waiting for child processor chain to complete.", (Object[])new Object[]{e}));
            }
            return result;
        };
    }

    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.processorChains);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.processorChains, LOGGER);
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.processorChains);
    }

    @Override
    public void setMuleContext(MuleContext muleContext) {
        super.setMuleContext(muleContext);
        LifecycleUtils.setMuleContextIfNeeded(this.processorChains, muleContext);
    }

    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.processorChains, this.muleContext);
    }
}

