/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.launcher.log4j2;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LoggerContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.module.launcher.log4j2.ArtifactAwareContextSelector;
import org.mule.runtime.module.launcher.log4j2.LoggerContextReaperThreadFactory;

final class LoggerContextCache
implements Disposable {
    private static final long DEFAULT_DISPOSE_DELAY_IN_MILLIS = 15000L;
    private final ArtifactAwareContextSelector artifactAwareContextSelector;
    private volatile Int2ObjectMap<LoggerContext> builtContexts = new Int2ObjectOpenHashMap();
    private final Cache<Integer, LoggerContext> activeContexts;
    private final Cache<Integer, LoggerContext> disposedContexts;
    private final ScheduledExecutorService executorService;
    private Long disposeDelayInMillis;

    LoggerContextCache(ArtifactAwareContextSelector artifactAwareContextSelector, ClassLoader reaperContextClassLoader) {
        this.acquireContextDisposeDelay();
        this.artifactAwareContextSelector = artifactAwareContextSelector;
        this.activeContexts = CacheBuilder.newBuilder().build();
        this.disposedContexts = CacheBuilder.newBuilder().expireAfterWrite(this.disposeDelayInMillis.longValue(), TimeUnit.MILLISECONDS).removalListener(notification -> {
            this.stop((LoggerContext)notification.getValue());
            this.activeContexts.invalidate(notification.getKey());
            Int2ObjectOpenHashMap newBuiltContexts = new Int2ObjectOpenHashMap(this.builtContexts);
            newBuiltContexts.remove(((Integer)notification.getKey()).intValue());
            this.builtContexts = newBuiltContexts;
        }).build();
        this.executorService = Executors.newScheduledThreadPool(1, new LoggerContextReaperThreadFactory(reaperContextClassLoader));
    }

    private void stop(LoggerContext loggerContext) {
        if (loggerContext != null && !loggerContext.isStopping() && !loggerContext.isStopped()) {
            loggerContext.stop();
        }
    }

    private void acquireContextDisposeDelay() {
        try {
            this.disposeDelayInMillis = Long.valueOf(System.getProperty("mule.log.context.dispose.delay.millis"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.disposeDelayInMillis == null) {
            this.disposeDelayInMillis = 15000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoggerContext getLoggerContext(ClassLoader classLoader) {
        LoggerContext ctx;
        block11: {
            try {
                int key = this.computeKey(classLoader);
                ctx = (LoggerContext)this.builtContexts.get(key);
                if (ctx != null) break block11;
                LoggerContextCache loggerContextCache = this;
                synchronized (loggerContextCache) {
                    ctx = (LoggerContext)this.builtContexts.get(key);
                    if (ctx == null) {
                        ctx = this.doGetLoggerContext(classLoader, key);
                    }
                }
            }
            catch (ExecutionException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not init logger context "), (Throwable)e);
            }
        }
        if (ctx.getState() == LifeCycle.State.INITIALIZED) {
            LoggerContextCache loggerContextCache = this;
            synchronized (loggerContextCache) {
                if (ctx.getState() == LifeCycle.State.INITIALIZED) {
                    ctx.start();
                }
            }
        }
        return ctx;
    }

    protected LoggerContext doGetLoggerContext(ClassLoader classLoader, Integer key) throws ExecutionException {
        return (LoggerContext)this.activeContexts.get((Object)key, () -> {
            if (this.builtContexts.containsKey(key.intValue())) {
                return (LoggerContext)this.builtContexts.get(key.intValue());
            }
            LoggerContext context = this.artifactAwareContextSelector.buildContext(classLoader);
            Int2ObjectOpenHashMap newBuiltContexts = new Int2ObjectOpenHashMap(this.builtContexts);
            newBuiltContexts.put(key.intValue(), (Object)context);
            this.builtContexts = newBuiltContexts;
            return context;
        });
    }

    void remove(ClassLoader classLoader) {
        Integer key = this.computeKey(classLoader);
        LoggerContext context = (LoggerContext)this.activeContexts.getIfPresent((Object)key);
        if (context != null) {
            this.disposeContext(key, context);
        }
    }

    void remove(LoggerContext context) {
        for (Map.Entry entry : this.activeContexts.asMap().entrySet()) {
            if (entry.getValue() != context) continue;
            this.disposeContext((Integer)entry.getKey(), context);
            return;
        }
    }

    List<LoggerContext> getAllLoggerContexts() {
        return ImmutableList.copyOf(this.activeContexts.asMap().values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeContext(Integer key, LoggerContext loggerContext) {
        if (this.isDisposedClassLoader(key)) {
            return;
        }
        this.disposedContexts.put((Object)key, (Object)loggerContext);
        ScheduledExecutorService scheduledExecutorService = this.executorService;
        synchronized (scheduledExecutorService) {
            if (!this.executorService.isShutdown()) {
                this.executorService.schedule(() -> this.disposedContexts.cleanUp(), this.disposeDelayInMillis + 1L, TimeUnit.MILLISECONDS);
            }
        }
    }

    private int computeKey(ClassLoader classLoader) {
        return classLoader.hashCode();
    }

    private boolean isDisposedClassLoader(int classLoaderHashCode) {
        return this.disposedContexts.asMap().containsKey(classLoaderHashCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        ScheduledExecutorService scheduledExecutorService = this.executorService;
        synchronized (scheduledExecutorService) {
            this.executorService.shutdownNow();
        }
        for (LoggerContext loggerContext : this.activeContexts.asMap().values()) {
            this.stop(loggerContext);
        }
        this.activeContexts.invalidateAll();
        this.builtContexts.clear();
        this.disposedContexts.invalidateAll();
        this.disposedContexts.cleanUp();
    }
}

