/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.phase;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.model.factory.TypeDeclarationModelFactory;
import org.raml.v2.internal.impl.commons.nodes.ExampleDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.rule.XmlSchemaValidationRule;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.impl.v10.type.AnyResolvedType;
import org.raml.v2.internal.impl.v10.type.FileResolvedType;
import org.raml.v2.internal.impl.v10.type.StringResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeToRuleVisitor;
import org.raml.v2.internal.impl.v10.type.TypeToXmlSchemaVisitor;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.NullNodeImpl;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.nodes.jackson.JNodeParser;
import org.raml.yagi.framework.nodes.snakeyaml.NodeParser;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.util.NodeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExampleValidationPhase
implements Phase {
    private ResourceLoader resourceLoader;

    public ExampleValidationPhase(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Node apply(Node tree) {
        List descendantsWith = tree.findDescendantsWith(ExampleDeclarationNode.class);
        for (ExampleDeclarationNode exampleTypeNode : descendantsWith) {
            Node validate;
            if (!exampleTypeNode.isStrict().booleanValue()) continue;
            TypeDeclarationNode type = (TypeDeclarationNode)NodeUtils.getAncestor((Node)exampleTypeNode, TypeDeclarationNode.class);
            Node exampleValue = exampleTypeNode.getExampleValue();
            if (type == null || (validate = this.validate(type, exampleValue)) == null) continue;
            exampleValue.replaceWith(validate);
        }
        return tree;
    }

    @Nullable
    public Node validate(TypeDeclarationNode type, String exampleValue) {
        StringNodeImpl exampleValueNode = new StringNodeImpl(exampleValue);
        if (exampleValue == null || StringUtils.isBlank((String)exampleValue) && !(type.getResolvedType() instanceof StringResolvedType)) {
            exampleValueNode = new NullNodeImpl();
        } else if (!(type.getResolvedType() instanceof StringResolvedType || type.getResolvedType() instanceof FileResolvedType || this.isJsonValue(exampleValue) || this.isXmlValue(exampleValue))) {
            exampleValueNode = NodeParser.parse(this.resourceLoader, "", exampleValue);
        }
        return this.validate(type, (Node)exampleValueNode);
    }

    @Nullable
    public Node validate(TypeDeclarationNode type, Node exampleValue) {
        ResolvedType resolvedType = type.getResolvedType();
        if (resolvedType instanceof AnyResolvedType) {
            return null;
        }
        if (exampleValue instanceof StringNode && !(resolvedType instanceof StringResolvedType) && !this.isExternalSchemaType(resolvedType)) {
            String value = ((StringNode)exampleValue).getValue();
            if (this.isXmlValue(value)) {
                return this.validateXml(type, resolvedType, value);
            }
            if (this.isJsonValue(value)) {
                return this.validateJson(exampleValue, resolvedType, value);
            }
        }
        if (exampleValue instanceof ErrorNode) {
            return exampleValue;
        }
        if (exampleValue != null) {
            Rule rule = (Rule)resolvedType.visit((TypeVisitor)new TypeToRuleVisitor(this.resourceLoader));
            return rule != null ? rule.apply(exampleValue) : null;
        }
        return null;
    }

    protected Node validateJson(Node exampleValue, ResolvedType resolvedType, String value) {
        Rule rule = (Rule)resolvedType.visit((TypeVisitor)new TypeToRuleVisitor(this.resourceLoader));
        Node parse = JNodeParser.parse((ResourceLoader)this.resourceLoader, (String)"", (String)value);
        if (parse.getType() != NodeType.Error) {
            Node apply = rule.apply(parse);
            List errorNodeList = apply.findDescendantsWith(ErrorNode.class);
            if (apply instanceof ErrorNode) {
                errorNodeList.add(0, (ErrorNode)apply);
            }
            if (!errorNodeList.isEmpty()) {
                String errorMessage = "";
                for (ErrorNode errorNode : errorNodeList) {
                    if (errorMessage.isEmpty()) {
                        errorMessage = "- " + errorNode.getErrorMessage();
                        continue;
                    }
                    errorMessage = errorMessage + "\n- " + errorNode.getErrorMessage();
                }
                return ErrorNodeFactory.createInvalidJsonExampleNode(errorMessage);
            }
            return exampleValue;
        }
        return parse;
    }

    @Nullable
    protected Node validateXml(TypeDeclarationNode type, ResolvedType resolvedType, String value) {
        TypeToXmlSchemaVisitor typeToXmlSchemaVisitor = new TypeToXmlSchemaVisitor();
        typeToXmlSchemaVisitor.transform(new TypeDeclarationModelFactory().create((Node)type).rootElementName(), resolvedType);
        XmlSchema schema = typeToXmlSchemaVisitor.getSchema();
        StringWriter xsd = new StringWriter();
        schema.write((Writer)xsd);
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema1 = factory.newSchema(new StreamSource(new StringReader(xsd.toString())));
            Validator validator = schema1.newValidator();
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", XmlSchemaValidationRule.expandEntities == false);
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", XmlSchemaValidationRule.externalEntities);
            xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", XmlSchemaValidationRule.externalEntities);
            validator.validate(new SAXSource(new NamespaceFilter(xmlReader, TypeToXmlSchemaVisitor.getTargetNamespace((ResolvedType)resolvedType)), new InputSource(new StringReader(value))));
        }
        catch (IOException | SAXException e) {
            return ErrorNodeFactory.createInvalidXmlExampleNode(e.getMessage());
        }
        return null;
    }

    private boolean isXmlValue(String value) {
        return value.trim().startsWith("<");
    }

    private boolean isJsonValue(String value) {
        return value.trim().startsWith("{") || value.trim().startsWith("[");
    }

    private boolean isExternalSchemaType(ResolvedType resolvedType) {
        return resolvedType instanceof XmlSchemaExternalType || resolvedType instanceof JsonSchemaExternalType;
    }

    private static class NamespaceFilter
    extends XMLFilterImpl {
        String requiredNamespace;

        public NamespaceFilter(XMLReader parent, String requiredNamespace) {
            super(parent);
            this.requiredNamespace = requiredNamespace;
        }

        @Override
        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            if (!arg0.equals(this.requiredNamespace)) {
                arg0 = this.requiredNamespace;
            }
            super.startElement(arg0, arg1, arg2, arg3);
        }
    }
}

