/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.snakeyaml;

import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.nodes.KeyValueNodeImpl;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.snakeyaml.RamlParsingLimitsController;
import org.raml.yagi.framework.nodes.snakeyaml.SYArrayNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYBooleanNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYFloatingNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYIncludeNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYIntegerNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYNullNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYObjectNode;
import org.raml.yagi.framework.nodes.snakeyaml.SYStringNode;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class SYModelWrapper {
    private ResourceLoader resourceLoader;
    private String resourcePath;
    private RamlParsingLimitsController controller = new RamlParsingLimitsController();
    public static final Tag INCLUDE_TAG = new Tag("!include");

    public SYModelWrapper(ResourceLoader resourceLoader, String resourcePath) {
        this.resourceLoader = resourceLoader;
        this.resourcePath = resourcePath;
    }

    public Node wrap(org.yaml.snakeyaml.nodes.Node node, int depth) {
        this.controller.verifyNode(node, depth);
        if (node.getNodeId() == NodeId.mapping) {
            return this.wrap((MappingNode)node, depth);
        }
        if (node.getNodeId() == NodeId.sequence) {
            return this.wrap((SequenceNode)node, depth);
        }
        if (node.getNodeId() == NodeId.scalar) {
            return this.wrap((ScalarNode)node);
        }
        throw new IllegalStateException("Invalid node type");
    }

    private SYObjectNode wrap(MappingNode mappingNode, int depth) {
        if (mappingNode.isMerged()) {
            new MappingNodeMerger().merge(mappingNode);
        }
        SYObjectNode mapping = new SYObjectNode(mappingNode, this.resourceLoader, this.resourcePath);
        for (NodeTuple nodeTuple : mappingNode.getValue()) {
            Node key = this.wrap(nodeTuple.getKeyNode(), depth + 1);
            Node value = this.wrap(nodeTuple.getValueNode(), depth + 1);
            KeyValueNodeImpl keyValue = new KeyValueNodeImpl(key, value);
            mapping.addChild((Node)keyValue);
        }
        return mapping;
    }

    private Node wrap(ScalarNode scalarNode) {
        Tag tag = scalarNode.getTag();
        if (INCLUDE_TAG.equals((Object)tag)) {
            return new SYIncludeNode(scalarNode, this.resourcePath, this.resourceLoader);
        }
        if (Tag.NULL.equals((Object)tag)) {
            return new SYNullNode((org.yaml.snakeyaml.nodes.Node)scalarNode, this.resourcePath, this.resourceLoader);
        }
        if (Tag.FLOAT.equals((Object)tag)) {
            return new SYFloatingNode(scalarNode, this.resourcePath, this.resourceLoader);
        }
        if (Tag.INT.equals((Object)tag)) {
            SYIntegerNode syIntegerNode = new SYIntegerNode(scalarNode, this.resourcePath, this.resourceLoader);
            try {
                syIntegerNode.getValue();
                return syIntegerNode;
            }
            catch (NumberFormatException e) {
                return new SYStringNode(scalarNode, this.resourcePath, this.resourceLoader);
            }
        }
        String value = scalarNode.getValue();
        if (Tag.BOOL.equals((Object)tag) && (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false"))) {
            return new SYBooleanNode(scalarNode, this.resourcePath, this.resourceLoader);
        }
        return new SYStringNode(scalarNode, this.resourcePath, this.resourceLoader);
    }

    private SYArrayNode wrap(SequenceNode sequenceNode, int depth) {
        SYArrayNode sequence = new SYArrayNode(sequenceNode, this.resourcePath, this.resourceLoader);
        for (org.yaml.snakeyaml.nodes.Node node : sequenceNode.getValue()) {
            sequence.addChild(this.wrap(node, depth + 1));
        }
        return sequence;
    }

    private static class MappingNodeMerger
    extends SafeConstructor {
        private MappingNodeMerger() {
        }

        void merge(MappingNode mappingNode) {
            this.flattenMapping(mappingNode);
        }
    }
}

