/*
 * Decompiled with CFR 0.152.
 */
package amf.core.registries;

import amf.client.plugins.AMFDocumentPlugin;
import amf.client.plugins.AMFDomainPlugin;
import amf.client.plugins.AMFFeaturePlugin;
import amf.client.plugins.AMFPlugin;
import amf.client.plugins.AMFSyntaxPlugin;
import amf.core.metamodel.Obj;
import amf.core.model.domain.AnnotationGraphLoader;
import amf.core.registries.AMFDomainEntityResolver;
import amf.core.registries.AMFDomainRegistry$;
import amf.core.validation.AMFPayloadValidationPlugin;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AMFPluginsRegistry$ {
    public static AMFPluginsRegistry$ MODULE$;
    private final HashMap<String, AMFSyntaxPlugin> syntaxPluginIDRegistry;
    private final HashMap<String, AMFSyntaxPlugin> syntaxPluginRegistry;
    private final HashMap<String, Seq<AMFDocumentPlugin>> documentPluginRegistry;
    private final HashMap<String, AMFDocumentPlugin> documentPluginIDRegistry;
    private final HashMap<String, Seq<AMFDocumentPlugin>> documentPluginVendorsRegistry;
    private final HashMap<String, AMFDomainPlugin> domainPluginRegistry;
    private final HashMap<String, AMFFeaturePlugin> featurePluginIDRegistry;
    private final HashMap<String, AMFFeaturePlugin> featurePlugin;
    private final HashMap<String, Seq<AMFPayloadValidationPlugin>> payloadValidationPluginRegistry;
    private final HashMap<String, AMFPayloadValidationPlugin> payloadValidationPluginIDRegistry;

    static {
        new AMFPluginsRegistry$();
    }

    private HashMap<String, AMFSyntaxPlugin> syntaxPluginIDRegistry() {
        return this.syntaxPluginIDRegistry;
    }

    private HashMap<String, AMFSyntaxPlugin> syntaxPluginRegistry() {
        return this.syntaxPluginRegistry;
    }

    private HashMap<String, Seq<AMFDocumentPlugin>> documentPluginRegistry() {
        return this.documentPluginRegistry;
    }

    private HashMap<String, AMFDocumentPlugin> documentPluginIDRegistry() {
        return this.documentPluginIDRegistry;
    }

    private HashMap<String, Seq<AMFDocumentPlugin>> documentPluginVendorsRegistry() {
        return this.documentPluginVendorsRegistry;
    }

    private HashMap<String, AMFDomainPlugin> domainPluginRegistry() {
        return this.domainPluginRegistry;
    }

    private HashMap<String, AMFFeaturePlugin> featurePluginIDRegistry() {
        return this.featurePluginIDRegistry;
    }

    private HashMap<String, AMFFeaturePlugin> featurePlugin() {
        return this.featurePlugin;
    }

    private HashMap<String, Seq<AMFPayloadValidationPlugin>> payloadValidationPluginRegistry() {
        return this.payloadValidationPluginRegistry;
    }

    private HashMap<String, AMFPayloadValidationPlugin> payloadValidationPluginIDRegistry() {
        return this.payloadValidationPluginIDRegistry;
    }

    public Iterable<AMFPlugin> plugins() {
        return (Iterable)((TraversableLike)((TraversableLike)this.syntaxPluginIDRegistry().values().$plus$plus((GenTraversableOnce)this.documentPluginIDRegistry().values(), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.domainPluginRegistry().values(), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.featurePluginIDRegistry().values(), Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<AMFDocumentPlugin> documentPlugins() {
        return this.documentPluginIDRegistry().values();
    }

    public void registerSyntaxPlugin(AMFSyntaxPlugin syntaxPlugin) {
        Option option = this.syntaxPluginIDRegistry().get((Object)syntaxPlugin.ID());
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.syntaxPluginIDRegistry().put((Object)syntaxPlugin.ID(), (Object)syntaxPlugin);
            syntaxPlugin.supportedMediaTypes().foreach((Function1 & Serializable & scala.Serializable)mediaType -> {
                boolean bl = false;
                Some some = null;
                Option option = MODULE$.syntaxPluginRegistry().get(mediaType);
                if (option instanceof Some) {
                    bl = true;
                    some = (Some)option;
                    AMFSyntaxPlugin plugin = (AMFSyntaxPlugin)some.value();
                    String string = plugin.ID();
                    String string2 = syntaxPlugin.ID();
                    if (string == null) {
                        if (string2 == null) return BoxedUnit.UNIT;
                    } else if (string.equals(string2)) {
                        return BoxedUnit.UNIT;
                    }
                }
                if (None$.MODULE$.equals(option)) {
                    return MODULE$.syntaxPluginRegistry().put(mediaType, (Object)syntaxPlugin);
                }
                if (!bl) throw new MatchError((Object)option);
                AMFSyntaxPlugin plugin = (AMFSyntaxPlugin)some.value();
                throw new Exception(new StringBuilder(53).append("Cannot register ").append(syntaxPlugin.ID()).append(" for media type ").append((String)mediaType).append(", ").append(plugin.ID()).append(" already registered").toString());
            });
            this.registerDependencies(syntaxPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public String cleanMediaType(String mediaType) {
        return mediaType.contains(";") ? (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])mediaType.split(";"))).head() : mediaType;
    }

    public Option<AMFSyntaxPlugin> syntaxPluginForMediaType(String mediaType) {
        Option option;
        String normalizedMediaType = this.cleanMediaType(mediaType);
        Option option2 = this.syntaxPluginRegistry().get((Object)mediaType);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AMFSyntaxPlugin plugin = (AMFSyntaxPlugin)some.value();
            option = new Some((Object)plugin);
        } else {
            option = this.syntaxPluginRegistry().get((Object)this.simpleMediaType(normalizedMediaType));
        }
        return option;
    }

    public void registerFeaturePlugin(AMFFeaturePlugin featurePlugin) {
        Option option = this.featurePluginIDRegistry().get((Object)featurePlugin.ID());
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.featurePluginIDRegistry().put((Object)featurePlugin.ID(), (Object)featurePlugin);
            this.registerDependencies(featurePlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public Seq<AMFFeaturePlugin> featurePlugins() {
        return this.featurePluginIDRegistry().values().toSeq();
    }

    public void registerDocumentPlugin(AMFDocumentPlugin documentPlugin) {
        Option option = this.documentPluginIDRegistry().get((Object)documentPlugin.ID());
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.documentPluginIDRegistry().put((Object)documentPlugin.ID(), (Object)documentPlugin);
            documentPlugin.serializableAnnotations().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                AnnotationGraphLoader unloader = (AnnotationGraphLoader)tuple2._2();
                Option<AnnotationGraphLoader> option = AMFDomainRegistry$.MODULE$.registerAnnotation(name, unloader);
                return option;
            });
            documentPlugin.documentSyntaxes().foreach((Function1 & Serializable & scala.Serializable)mediaType -> {
                Seq plugins = (Seq)MODULE$.documentPluginRegistry().getOrElse(mediaType, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                return MODULE$.documentPluginRegistry().put(mediaType, plugins.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AMFDocumentPlugin[]{documentPlugin})), Seq$.MODULE$.canBuildFrom()));
            });
            documentPlugin.vendors().foreach((Function1 & Serializable & scala.Serializable)vendor -> {
                Seq plugins = (Seq)MODULE$.documentPluginVendorsRegistry().getOrElse(vendor, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$));
                return MODULE$.documentPluginVendorsRegistry().put(vendor, plugins.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AMFDocumentPlugin[]{documentPlugin})), Seq$.MODULE$.canBuildFrom()));
            });
            documentPlugin.modelEntities().foreach((Function1 & Serializable & scala.Serializable)entity -> AMFDomainRegistry$.MODULE$.registerModelEntity((Obj)entity));
            documentPlugin.modelEntitiesResolver().foreach((Function1 & Serializable & scala.Serializable)resolver -> {
                AMFDomainRegistry$.MODULE$.registerModelEntityResolver(resolver);
                return BoxedUnit.UNIT;
            });
            this.registerDependencies(documentPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public Seq<AMFDocumentPlugin> documentPluginForMediaType(String mediaType) {
        return (Seq)((SeqLike)this.documentPluginRegistry().getOrElse((Object)mediaType, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.priority()), (Ordering)Ordering.Int$.MODULE$);
    }

    public Seq<AMFPayloadValidationPlugin> dataNodeValidatorPluginForMediaType(String mediaType) {
        return (Seq)this.payloadValidationPluginRegistry().getOrElse((Object)mediaType, (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Option<AMFDocumentPlugin> documentPluginForID(String ID) {
        return this.documentPluginIDRegistry().get((Object)ID);
    }

    public Seq<AMFDocumentPlugin> documentPluginForVendor(String vendor) {
        return (Seq)((SeqLike)this.documentPluginVendorsRegistry().getOrElse((Object)vendor, (Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$))).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.priority()), (Ordering)Ordering.Int$.MODULE$);
    }

    public void registerDomainPlugin(AMFDomainPlugin domainPlugin) {
        Option option = this.domainPluginRegistry().get((Object)domainPlugin.ID());
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            domainPlugin.serializableAnnotations().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String name = (String)tuple2._1();
                AnnotationGraphLoader unloader = (AnnotationGraphLoader)tuple2._2();
                Option<AnnotationGraphLoader> option = AMFDomainRegistry$.MODULE$.registerAnnotation(name, unloader);
                return option;
            });
            this.domainPluginRegistry().put((Object)domainPlugin.ID(), (Object)domainPlugin);
            domainPlugin.modelEntities().foreach((Function1 & Serializable & scala.Serializable)entity -> AMFDomainRegistry$.MODULE$.registerModelEntity((Obj)entity));
            Option<AMFDomainEntityResolver> option2 = domainPlugin.modelEntitiesResolver();
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                AMFDomainEntityResolver resolver = (AMFDomainEntityResolver)some.value();
                AMFDomainRegistry$.MODULE$.registerModelEntityResolver(resolver);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            this.registerDependencies(domainPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void unregisterDomainPlugin(AMFDomainPlugin domainPlugin) {
        this.domainPluginRegistry().remove((Object)domainPlugin.ID());
        domainPlugin.serializableAnnotations().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AMFPluginsRegistry$.$anonfun$unregisterDomainPlugin$1(x0$1);
            return BoxedUnit.UNIT;
        });
        domainPlugin.modelEntities().foreach((Function1 & Serializable & scala.Serializable)entity -> {
            AMFDomainRegistry$.MODULE$.unregisterModelEntity(entity);
            return BoxedUnit.UNIT;
        });
        Option<AMFDomainEntityResolver> option = domainPlugin.modelEntitiesResolver();
        if (option instanceof Some) {
            Some some = (Some)option;
            AMFDomainEntityResolver resolver = (AMFDomainEntityResolver)some.value();
            AMFDomainRegistry$.MODULE$.unregisterModelEntityResolver(resolver);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void registerPayloadValidationPlugin(AMFPayloadValidationPlugin validationPlugin) {
        Option option = this.payloadValidationPluginIDRegistry().get((Object)validationPlugin.ID());
        if (option instanceof Some) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            validationPlugin.payloadMediaType().foreach((Function1 & Serializable & scala.Serializable)mt -> {
                AMFPluginsRegistry$.$anonfun$registerPayloadValidationPlugin$1(validationPlugin, mt);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String simpleMediaType(String mediaType) {
        Option option;
        String[] stringArray = mediaType.split("/");
        Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
            String main = (String)((SeqLike)option2.get()).apply(0);
            String sub = (String)((SeqLike)option2.get()).apply(1);
            if (sub.indexOf("+") > -1) {
                return new StringBuilder(1).append(main).append("/").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sub.split("\\+"))).last()).toString();
            }
        }
        if ((option = Array$.MODULE$.unapplySeq((Object)stringArray)).isEmpty()) return mediaType;
        if (option.get() == null) return mediaType;
        if (((SeqLike)option.get()).lengthCompare(2) != 0) return mediaType;
        String main = (String)((SeqLike)option.get()).apply(0);
        String sub = (String)((SeqLike)option.get()).apply(1);
        if (sub.indexOf(".") <= -1) return mediaType;
        return new StringBuilder(1).append(main).append("/").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sub.split("\\."))).last()).toString();
    }

    public void registerDependencies(AMFPlugin plugin) {
        plugin.dependencies().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AMFPluginsRegistry$.$anonfun$registerDependencies$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public void unregisterDependencies(AMFPlugin plugin) {
        plugin.dependencies().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            AMFPluginsRegistry$.$anonfun$unregisterDependencies$1(x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$unregisterDomainPlugin$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String name = (String)tuple2._1();
        AMFDomainRegistry$.MODULE$.unregisterAnnotaion(name);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$registerPayloadValidationPlugin$1(AMFPayloadValidationPlugin validationPlugin$1, String mt) {
        boolean bl = false;
        Some some = null;
        Option option = MODULE$.payloadValidationPluginRegistry().get((Object)mt);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            Seq list = (Seq)some.value();
            if (!list.contains((Object)validationPlugin$1)) {
                MODULE$.payloadValidationPluginRegistry().update((Object)mt, list.$colon$plus((Object)validationPlugin$1, Seq$.MODULE$.canBuildFrom()));
                MODULE$.payloadValidationPluginIDRegistry().update((Object)validationPlugin$1.ID(), (Object)validationPlugin$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (None$.MODULE$.equals(option)) {
            MODULE$.payloadValidationPluginRegistry().update((Object)mt, (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AMFPayloadValidationPlugin[]{validationPlugin$1})));
            MODULE$.payloadValidationPluginIDRegistry().update((Object)validationPlugin$1.ID(), (Object)validationPlugin$1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (!bl) throw new MatchError((Object)option);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$registerDependencies$1(AMFPlugin x0$1) {
        AMFPlugin aMFPlugin = x0$1;
        if (aMFPlugin instanceof AMFDomainPlugin) {
            AMFDomainPlugin aMFDomainPlugin = (AMFDomainPlugin)aMFPlugin;
            MODULE$.registerDomainPlugin(aMFDomainPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (aMFPlugin instanceof AMFDocumentPlugin) {
            AMFDocumentPlugin aMFDocumentPlugin = (AMFDocumentPlugin)aMFPlugin;
            MODULE$.registerDocumentPlugin(aMFDocumentPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (aMFPlugin instanceof AMFSyntaxPlugin) {
            AMFSyntaxPlugin aMFSyntaxPlugin = (AMFSyntaxPlugin)aMFPlugin;
            MODULE$.registerSyntaxPlugin(aMFSyntaxPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$unregisterDependencies$1(AMFPlugin x0$1) {
        AMFPlugin aMFPlugin = x0$1;
        if (aMFPlugin instanceof AMFDomainPlugin) {
            AMFDomainPlugin aMFDomainPlugin = (AMFDomainPlugin)aMFPlugin;
            MODULE$.unregisterDomainPlugin(aMFDomainPlugin);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (aMFPlugin instanceof AMFDocumentPlugin) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (aMFPlugin instanceof AMFSyntaxPlugin) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private AMFPluginsRegistry$() {
        MODULE$ = this;
        this.syntaxPluginIDRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.syntaxPluginRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentPluginRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentPluginIDRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.documentPluginVendorsRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.domainPluginRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.featurePluginIDRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.featurePlugin = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.payloadValidationPluginRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.payloadValidationPluginIDRegistry = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
    }
}

