/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class NameUtils {
    private static final Pattern wordBound = Pattern.compile("\\b(?=\\w)");
    public static final String COMPONENT_NAME_SEPARATOR = "-";

    protected NameUtils() {
    }

    public static String hyphenize(String camelCaseName) {
        return NameUtils.camelScatterConcat(camelCaseName, '-');
    }

    public static String underscorize(String camelCaseName) {
        return NameUtils.camelScatterConcat(camelCaseName, '_');
    }

    public static String toCamelCase(String value, String separator) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return value;
        }
        String[] parts = value.split(separator);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim().toLowerCase();
            if (i == 0) {
                result.append(part);
                continue;
            }
            result.append(StringUtils.capitalize((String)part));
        }
        return result.toString();
    }

    private static String camelScatterConcat(String camelCaseName, char concatChar) {
        if (StringUtils.isBlank((CharSequence)camelCaseName)) {
            return camelCaseName;
        }
        StringBuilder result = new StringBuilder();
        String[] parts = camelCaseName.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i].trim().toLowerCase();
            result.append(part);
            char lastChar = part.charAt(part.length() - 1);
            if (lastChar == concatChar || lastChar == '_' || lastChar == '-' || i >= parts.length - 1) continue;
            result.append(concatChar);
        }
        return result.toString();
    }

    public static String sanitizeName(String originalName) {
        return originalName.replaceAll("[^\\w|\\.\\-]", "");
    }

    public static String sanitizeName(Optional<String> originalName) {
        return originalName.map(name -> NameUtils.sanitizeName(name)).orElse("");
    }

    private static String humanize(String name) {
        return StringUtils.capitalize((String)name.replace("_", " ").replace(COMPONENT_NAME_SEPARATOR, " "));
    }

    public static String titleize(String name) {
        return wordBound.splitAsStream(NameUtils.humanize(NameUtils.underscorize(name))).map(StringUtils::capitalize).collect(Collectors.joining());
    }
}

