/*
 * Decompiled with CFR 0.152.
 */
package amf.core;

import amf.client.plugins.AMFDocumentPlugin;
import amf.client.plugins.AMFSyntaxPlugin;
import amf.core.AMFSerializer$;
import amf.core.benchmark.ExecutionLog$;
import amf.core.emitter.RenderOptions;
import amf.core.emitter.ShapeRenderOptions;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.ExternalFragment;
import amf.core.parser.SyamlParsedDocument;
import amf.core.parser.SyamlParsedDocument$;
import amf.core.rdf.RdfFramework;
import amf.core.rdf.RdfModelDocument;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Platform;
import amf.core.remote.Vendor$;
import amf.plugins.document.graph.AMFGraphPlugin$;
import amf.plugins.document.graph.emitter.JsonLdEmitter$;
import amf.plugins.syntax.RdfSyntaxPlugin$;
import java.io.Serializable;
import java.io.StringWriter;
import org.mulesoft.common.io.Output;
import org.mulesoft.common.io.Output$;
import org.yaml.builder.DocBuilder;
import org.yaml.builder.JsonOutputBuilder;
import org.yaml.builder.JsonOutputBuilder$;
import org.yaml.builder.YDocumentBuilder;
import org.yaml.model.YDocument;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001\u0002\f\u0018\u0001qA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!A\u0001\b\u0001B\u0001B\u0003%Q\u0006\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\"\u0002#\u0001\t\u0003)\u0005\"B'\u0001\t\u0003q\u0005\"B+\u0001\t\u00031\u0006\"B?\u0001\t\u0003q\bbBA\u0014\u0001\u0011\u0005\u0011\u0011\u0006\u0005\b\u0003_\u0001A\u0011AA\u0019\u0011\u001d\tI\u0005\u0001C\u0005\u0003\u0017Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002J\u0001!I!!\u001d\t\u000f\u0005M\u0004\u0001\"\u0005\u0002v!9\u0011Q\u0012\u0001\u0005\n\u0005=uaBAI/!\u0005\u00111\u0013\u0004\u0007-]A\t!!&\t\r\u0011\u0013B\u0011AAL\u0011\u001d\tIJ\u0005C\u0001\u00037C\u0011\"!(\u0013#\u0003%\t!a(\u0003\u001b\u0005keiU3sS\u0006d\u0017N_3s\u0015\tA\u0012$\u0001\u0003d_J,'\"\u0001\u000e\u0002\u0007\u0005lgm\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010\"\u001b\u0005y\"\"\u0001\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\tz\"AB!osJ+g-\u0001\u0003v]&$\bCA\u0013+\u001b\u00051#BA\u0014)\u0003!!wnY;nK:$(BA\u0015\u0018\u0003\u0015iw\u000eZ3m\u0013\tYcE\u0001\u0005CCN,WK\\5u\u0003%iW\rZ5b)f\u0004X\r\u0005\u0002/k9\u0011qf\r\t\u0003a}i\u0011!\r\u0006\u0003em\ta\u0001\u0010:p_Rt\u0014B\u0001\u001b \u0003\u0019\u0001&/\u001a3fM&\u0011ag\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Qz\u0012A\u0002<f]\u0012|'/A\u0004paRLwN\\:\u0011\u0005mrT\"\u0001\u001f\u000b\u0005u:\u0012aB3nSR$XM]\u0005\u0003\u007fq\u0012QBU3oI\u0016\u0014x\n\u001d;j_:\u001c\u0018\u0001D:iCB,w\n\u001d;j_:\u001c\bCA\u001eC\u0013\t\u0019EH\u0001\nTQ\u0006\u0004XMU3oI\u0016\u0014x\n\u001d;j_:\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0004G\u0011&S5\n\u0014\t\u0003\u000f\u0002i\u0011a\u0006\u0005\u0006G\u0019\u0001\r\u0001\n\u0005\u0006Y\u0019\u0001\r!\f\u0005\u0006q\u0019\u0001\r!\f\u0005\u0006s\u0019\u0001\rA\u000f\u0005\b\u0001\u001a\u0001\n\u00111\u0001B\u0003E\u0011XM\u001c3fe\u0006\u001b\u0018\fR8dk6,g\u000e\u001e\u000b\u0002\u001fB\u0011\u0001kU\u0007\u0002#*\u0011!kF\u0001\u0007a\u0006\u00148/\u001a:\n\u0005Q\u000b&aE*zC6d\u0007+\u0019:tK\u0012$unY;nK:$\u0018a\u0004:f]\u0012,'\u000fV8Ck&dG-\u001a:\u0016\u0005]#HC\u0001-h)\tI&\rE\u0002[;~k\u0011a\u0017\u0006\u00039~\t!bY8oGV\u0014(/\u001a8u\u0013\tq6L\u0001\u0004GkR,(/\u001a\t\u0003=\u0001L!!Y\u0010\u0003\tUs\u0017\u000e\u001e\u0005\u0006G\"\u0001\u001d\u0001Z\u0001\tKb,7-\u001e;peB\u0011!,Z\u0005\u0003Mn\u0013\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000b!D\u0001\u0019A5\u0002\u000f\t,\u0018\u000e\u001c3feB\u0019!\u000e\u001d:\u000e\u0003-T!\u0001\u001b7\u000b\u00055t\u0017\u0001B=b[2T\u0011a\\\u0001\u0004_J<\u0017BA9l\u0005)!un\u0019\"vS2$WM\u001d\t\u0003gRd\u0001\u0001B\u0003v\u0011\t\u0007aOA\u0001U#\t9(\u0010\u0005\u0002\u001fq&\u0011\u0011p\b\u0002\b\u001d>$\b.\u001b8h!\tq20\u0003\u0002}?\t\u0019\u0011I\\=\u0002\u001dI,g\u000eZ3s)><&/\u001b;feV\u0019q0!\b\u0015\t\u0005\u0005\u00111\u0005\u000b\u00063\u0006\r\u0011\u0011\u0005\u0005\n\u0003\u000bI\u0011\u0011!a\u0002\u0003\u000f\t!\"\u001a<jI\u0016t7-\u001a\u00132!\u0019\tI!a\u0006\u0002\u001c5\u0011\u00111\u0002\u0006\u0005\u0003\u001b\ty!\u0001\u0002j_*!\u0011\u0011CA\n\u0003\u0019\u0019w.\\7p]*\u0019\u0011Q\u00038\u0002\u00115,H.Z:pMRLA!!\u0007\u0002\f\t1q*\u001e;qkR\u00042a]A\u000f\t\u0019\ty\"\u0003b\u0001m\n\tq\u000bC\u0003d\u0013\u0001\u000fA\rC\u0004\u0002&%\u0001\r!a\u0007\u0002\r]\u0014\u0018\u000e^3s\u00039\u0011XM\u001c3feR{7\u000b\u001e:j]\u001e$B!a\u000b\u0002.A\u0019!,X\u0017\t\u000b\rT\u00019\u00013\u0002\u0019I,g\u000eZ3s)>4\u0015\u000e\\3\u0015\r\u0005M\u0012qGA#)\rI\u0016Q\u0007\u0005\u0006G.\u0001\u001d\u0001\u001a\u0005\b\u0003sY\u0001\u0019AA\u001e\u0003\u0019\u0011X-\\8uKB!\u0011QHA!\u001b\t\tyDC\u0002\u0002:]IA!a\u0011\u0002@\tA\u0001\u000b\\1uM>\u0014X\u000e\u0003\u0004\u0002H-\u0001\r!L\u0001\u0005a\u0006$\b.\u0001\u0004sK:$WM]\u000b\u0005\u0003\u001b\nI\u0006\u0006\u0003\u0002P\u0005mCcA0\u0002R!I\u00111\u000b\u0007\u0002\u0002\u0003\u000f\u0011QK\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004CBA\u0005\u0003/\t9\u0006E\u0002t\u00033\"a!a\b\r\u0005\u00041\bbBA\u0013\u0019\u0001\u0007\u0011qK\u0001\ta\u0006\u00148/\u001a*eMV!\u0011\u0011MA7)\u0011\t\u0019'a\u001c\u0015\u0007}\u000b)\u0007C\u0005\u0002h5\t\t\u0011q\u0001\u0002j\u0005QQM^5eK:\u001cW\rJ\u001a\u0011\r\u0005%\u0011qCA6!\r\u0019\u0018Q\u000e\u0003\u0007\u0003?i!\u0019\u0001<\t\u000f\u0005\u0015R\u00021\u0001\u0002lQ\tQ&\u0001\tgS:$Gi\\7bS:\u0004F.^4j]R\u0011\u0011q\u000f\t\u0006=\u0005e\u0014QP\u0005\u0004\u0003wz\"AB(qi&|g\u000e\u0005\u0003\u0002\u0000\u0005%UBAAA\u0015\u0011\t\u0019)!\"\u0002\u000fAdWoZ5og*\u0019\u0011qQ\r\u0002\r\rd\u0017.\u001a8u\u0013\u0011\tY)!!\u0003#\u0005ke\tR8dk6,g\u000e\u001e)mk\u001eLg.A\bhKR$u.\\1j]BcWoZ5o+\t\ti(A\u0007B\u001b\u001a\u001bVM]5bY&TXM\u001d\t\u0003\u000fJ\u0019\"AE\u000f\u0015\u0005\u0005M\u0015\u0001B5oSR$\u0012aX\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\u0005\u0005&fA!\u0002$.\u0012\u0011Q\u0015\t\u0005\u0003O\u000b\t,\u0004\u0002\u0002**!\u00111VAW\u0003%)hn\u00195fG.,GMC\u0002\u00020~\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019,!+\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class AMFSerializer {
    private final BaseUnit unit;
    private final String mediaType;
    private final String vendor;
    private final RenderOptions options;
    private final ShapeRenderOptions shapeOptions;

    public static ShapeRenderOptions $lessinit$greater$default$5() {
        return AMFSerializer$.MODULE$.$lessinit$greater$default$5();
    }

    public static void init() {
        AMFSerializer$.MODULE$.init();
    }

    public SyamlParsedDocument renderAsYDocument() {
        YDocumentBuilder builder;
        AMFDocumentPlugin domainPlugin = this.getDomainPlugin();
        if (!domainPlugin.emit(this.unit, builder = new YDocumentBuilder(), this.options, this.shapeOptions)) {
            throw new Exception(new StringBuilder(43).append("Error unparsing syntax ").append(this.mediaType).append(" with domain plugin ").append(domainPlugin.ID()).toString());
        }
        return new SyamlParsedDocument((YDocument)builder.result(), SyamlParsedDocument$.MODULE$.apply$default$2());
    }

    public <T> Future<BoxedUnit> renderToBuilder(DocBuilder<T> builder, ExecutionContext executor) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                String string = $this.vendor;
                String string2 = Vendor$.MODULE$.AMF().name();
                if (string != null ? !string.equals(string2) : string2 != null) break block0;
                JsonLdEmitter$.MODULE$.emit($this.unit, builder, $this.options);
            }
        }, executor);
    }

    public <W> Future<BoxedUnit> renderToWriter(W writer, Output<W> evidence$1, ExecutionContext executor) {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.render(writer, evidence$1), executor);
    }

    public Future<String> renderToString(ExecutionContext executor) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.amf$core$AMFSerializer$$render(), executor);
    }

    public Future<BoxedUnit> renderToFile(Platform remote, String path, ExecutionContext executor) {
        return this.renderToString(executor).map((Function1 & Serializable & scala.Serializable)x$1 -> {
            remote.write(path, x$1);
            return BoxedUnit.UNIT;
        }, executor);
    }

    private <W> void render(W writer, Output<W> evidence$2) {
        ExecutionLog$.MODULE$.log(new StringBuilder(44).append("AMFSerializer#render: Rendering to ").append(this.mediaType).append(" (").append(this.vendor).append(" file) ").append(this.unit.location()).toString());
        String string = this.vendor;
        String string2 = Vendor$.MODULE$.AMF().name();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Object object;
            if (!this.options.isAmfJsonLdSerilization()) {
                this.parseRdf(writer, evidence$2);
                object = BoxedUnit.UNIT;
            } else {
                JsonOutputBuilder b = JsonOutputBuilder$.MODULE$.apply(writer, this.options.isPrettyPrint(), evidence$2);
                object = BoxesRunTime.boxToBoolean((boolean)JsonLdEmitter$.MODULE$.emit(this.unit, b, this.options));
            }
            return;
        }
        SyamlParsedDocument ast = this.renderAsYDocument();
        Option<AMFSyntaxPlugin> option = AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType(this.mediaType);
        if (option instanceof Some) {
            Some some = (Some)option;
            AMFSyntaxPlugin syntaxPlugin = (AMFSyntaxPlugin)some.value();
            syntaxPlugin.unparse(this.mediaType, ast, writer, evidence$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option) && this.unit instanceof ExternalFragment) {
            Output$.MODULE$.OutputOps(writer).append((CharSequence)((ExternalFragment)this.unit).encodes().raw().value(), evidence$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new Exception(new StringBuilder(35).append("Unsupported media type ").append(this.mediaType).append(" and vendor ").append(this.vendor).toString());
        }
    }

    private <W> void parseRdf(W writer, Output<W> evidence$3) {
        Option<RdfFramework> option = AMFGraphPlugin$.MODULE$.platform().rdfFramework();
        if (option instanceof Some) {
            Some some = (Some)option;
            RdfFramework r = (RdfFramework)some.value();
            RdfModelDocument d = new RdfModelDocument(r.unitToRdfModel(this.unit, this.options));
            RdfSyntaxPlugin$.MODULE$.unparse(this.mediaType, d, writer, evidence$3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public String amf$core$AMFSerializer$$render() {
        StringWriter w = new StringWriter();
        this.render(w, Output$.MODULE$.outputWriter());
        return w.toString();
    }

    public Option<AMFDocumentPlugin> findDomainPlugin() {
        Some some;
        Option option = AMFPluginsRegistry$.MODULE$.documentPluginForVendor(this.vendor).find((Function1 & Serializable & scala.Serializable)plugin -> BoxesRunTime.boxToBoolean((boolean)AMFSerializer.$anonfun$findDomainPlugin$1(this, plugin)));
        if (option instanceof Some) {
            Some some2 = (Some)option;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some2.value();
            some = new Some((Object)domainPlugin);
        } else if (None$.MODULE$.equals(option)) {
            some = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(this.mediaType).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.canUnparse(this.unit)));
        } else {
            throw new MatchError((Object)option);
        }
        return some;
    }

    private AMFDocumentPlugin getDomainPlugin() {
        return (AMFDocumentPlugin)this.findDomainPlugin().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new Exception(new StringBuilder(69).append("Cannot serialize domain model '").append($this.unit.location()).append("' for detected media type ").append($this.mediaType).append(" and vendor ").append($this.vendor).toString());
        });
    }

    public static final /* synthetic */ boolean $anonfun$findDomainPlugin$1(AMFSerializer $this, AMFDocumentPlugin plugin) {
        return plugin.documentSyntaxes().contains((Object)$this.mediaType) && plugin.canUnparse($this.unit);
    }

    public AMFSerializer(BaseUnit unit, String mediaType, String vendor, RenderOptions options, ShapeRenderOptions shapeOptions) {
        this.unit = unit;
        this.mediaType = mediaType;
        this.vendor = vendor;
        this.options = options;
        this.shapeOptions = shapeOptions;
    }
}

