/*
 * Decompiled with CFR 0.152.
 */
package amf.tools.canonical;

import amf.core.model.document.BaseUnit;
import amf.core.model.domain.DomainElement;
import amf.core.parser.ParserContext;
import amf.core.parser.ParserContext$;
import amf.core.rdf.RdfModel;
import amf.core.rdf.RdfModelParser;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Platform;
import amf.core.unsafe.PlatformSecrets;
import amf.core.vocabulary.Namespace$;
import amf.plugins.document.vocabularies.AMLPlugin$;
import amf.plugins.document.vocabularies.model.document.Dialect;
import amf.plugins.document.vocabularies.model.domain.NodeMapping;
import amf.plugins.domain.shapes.DataShapesDomainPlugin$;
import amf.plugins.domain.webapi.WebAPIDomainPlugin$;
import java.io.Serializable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class CanonicalWebAPITransformer$
implements PlatformSecrets {
    public static CanonicalWebAPITransformer$ MODULE$;
    private final String CANONICAL_WEBAPI_NAME;
    private final Platform platform;

    static {
        new CanonicalWebAPITransformer$();
    }

    @Override
    public Platform platform() {
        return this.platform;
    }

    @Override
    public void amf$core$unsafe$PlatformSecrets$_setter_$platform_$eq(Platform x$1) {
        this.platform = x$1;
    }

    public String CANONICAL_WEBAPI_NAME() {
        return this.CANONICAL_WEBAPI_NAME;
    }

    public Future<BoxedUnit> removeWebAPIPlugin() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AMFPluginsRegistry$.MODULE$.unregisterDomainPlugin(WebAPIDomainPlugin$.MODULE$);
            AMFPluginsRegistry$.MODULE$.unregisterDomainPlugin(DataShapesDomainPlugin$.MODULE$);
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Future<BoxedUnit> registerWebAPIPlugin() {
        return Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            AMFPluginsRegistry$.MODULE$.registerDomainPlugin(WebAPIDomainPlugin$.MODULE$);
            AMFPluginsRegistry$.MODULE$.registerDomainPlugin(DataShapesDomainPlugin$.MODULE$);
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public Option<Dialect> findWebAPIDialect() {
        return AMLPlugin$.MODULE$.registry().allDialects().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CanonicalWebAPITransformer$.$anonfun$findWebAPIDialect$1(x$1)));
    }

    public Map<String, String> buildCanonicalClassMapping() {
        Option<Dialect> option = this.findWebAPIDialect();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception("Cannot find WebAPI 1.0 Dialect in Dialect registry");
            }
            throw new MatchError(option);
        }
        Some some = (Some)option;
        Dialect webApiDialect = (Dialect)some.value();
        Seq nodeMappings2 = (Seq)webApiDialect.declares().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends DomainElement, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof NodeMapping) {
                    NodeMapping nodeMapping = (NodeMapping)A1;
                    object = nodeMapping;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(DomainElement x1) {
                DomainElement domainElement = x1;
                boolean bl = domainElement instanceof NodeMapping;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map map = (Map)nodeMappings2.foldLeft((Object)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map acc = (Map)tuple2._1();
            NodeMapping mapping = (NodeMapping)tuple2._2();
            Map map = acc.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)mapping.nodetypeMapping().value()), (Object)mapping.id()));
            return map;
        });
        return map;
    }

    public BaseUnit cleanAMFModel(BaseUnit unit) {
        BoxedUnit boxedUnit;
        Map<String, String> mapping = this.buildCanonicalClassMapping();
        RdfModel model = unit.toNativeRdfModel(unit.toNativeRdfModel$default$1());
        Model nativeModel = (Model)model.native();
        String doc = ((Resource)nativeModel.listSubjectsWithProperty(nativeModel.createProperty(Namespace$.MODULE$.Rdf().$plus("type").iri()), (RDFNode)nativeModel.createResource(Namespace$.MODULE$.Document().$plus("Document").iri())).next()).getURI();
        nativeModel.add(nativeModel.createResource(doc), nativeModel.createProperty(Namespace$.MODULE$.Rdf().$plus("type").iri()), (RDFNode)nativeModel.createResource(Namespace$.MODULE$.Meta().$plus("DialectInstance").iri()));
        Option<Dialect> option = this.findWebAPIDialect();
        if (option instanceof Some) {
            Some some = (Some)option;
            Dialect dialect = (Dialect)some.value();
            boxedUnit = nativeModel.add(nativeModel.createResource(doc), nativeModel.createProperty(Namespace$.MODULE$.Meta().$plus("definedBy").iri()), (RDFNode)nativeModel.createResource(dialect.id()));
        } else if (None$.MODULE$.equals(option)) {
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        ResIterator it = nativeModel.listSubjectsWithProperty(nativeModel.createProperty(Namespace$.MODULE$.Rdf().$plus("type").iri()), (RDFNode)nativeModel.createResource(Namespace$.MODULE$.Document().$plus("DomainElement").iri()));
        ListBuffer domainElements = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (it.hasNext()) {
            domainElements.$plus$eq((Object)((Resource)it.next()).getURI());
        }
        it = nativeModel.listSubjectsWithProperty(nativeModel.createProperty(Namespace$.MODULE$.Rdf().$plus("type").iri()), (RDFNode)nativeModel.createResource(Namespace$.MODULE$.Shapes().$plus("Shape").iri()));
        while (it.hasNext()) {
            domainElements.$plus$eq((Object)((Resource)it.next()).getURI());
        }
        scala.collection.mutable.Map domainElementsMapping = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        domainElements.foreach((Function1 & Serializable & scala.Serializable)domainElement -> {
            CanonicalWebAPITransformer$.$anonfun$cleanAMFModel$1(nativeModel, mapping, domainElementsMapping, domainElement);
            return BoxedUnit.UNIT;
        });
        domainElementsMapping.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String domainElement = (String)tuple2._1();
            String nodeMapping = (String)tuple2._2();
            nativeModel.add(nativeModel.createResource(domainElement), nativeModel.createProperty(Namespace$.MODULE$.Rdf().$plus("type").iri()), (RDFNode)nativeModel.createResource(Namespace$.MODULE$.Meta().$plus("DialectDomainElement").iri()));
            Model model = nativeModel.add(nativeModel.createResource(domainElement), nativeModel.createProperty(Namespace$.MODULE$.Rdf().$plus("type").iri()), (RDFNode)nativeModel.createResource(nodeMapping));
            return model;
        });
        return new RdfModelParser(this.platform(), new ParserContext(ParserContext$.MODULE$.apply$default$1(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3(), ParserContext$.MODULE$.apply$default$4(), ParserContext$.MODULE$.apply$default$5())).parse(model, unit.id());
    }

    public Future<BaseUnit> transform(BaseUnit unit) {
        return this.removeWebAPIPlugin().flatMap((Function1 & Serializable & scala.Serializable)_ -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> MODULE$.cleanAMFModel(unit), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)transformed -> MODULE$.registerWebAPIPlugin().map((Function1 & Serializable & scala.Serializable)_ -> transformed, ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    public static final /* synthetic */ boolean $anonfun$findWebAPIDialect$1(Dialect x$1) {
        String string = x$1.nameAndVersion();
        String string2 = MODULE$.CANONICAL_WEBAPI_NAME();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$cleanAMFModel$1(Model nativeModel$1, Map mapping$1, scala.collection.mutable.Map domainElementsMapping$1, String domainElement) {
        block9: {
            NodeIterator nodeIt = nativeModel$1.listObjectsOfProperty(nativeModel$1.createResource(domainElement), nativeModel$1.createProperty(Namespace$.MODULE$.Rdf().$plus("type").iri()));
            None$ foundShape = None$.MODULE$;
            None$ foundAnyShape = None$.MODULE$;
            boolean found = false;
            while (nodeIt.hasNext()) {
                BoxedUnit boxedUnit;
                String nextType = nodeIt.next().asResource().getURI();
                Option option = mapping$1.get((Object)nextType);
                if (option instanceof Some) {
                    BoxedUnit boxedUnit2;
                    Some some = (Some)option;
                    String dialectNode = (String)some.value();
                    if (!dialectNode.endsWith("#/declarations/Shape") && !dialectNode.endsWith("#/declarations/AnyShape")) {
                        found = true;
                        boxedUnit2 = domainElementsMapping$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)domainElement), (Object)dialectNode));
                    } else if (dialectNode.endsWith("#/declarations/Shape")) {
                        foundShape = new Some((Object)dialectNode);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (dialectNode.endsWith("#/declarations/AnyShape")) {
                        foundAnyShape = new Some((Object)dialectNode);
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    boxedUnit = boxedUnit2;
                    continue;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            if (!found && foundAnyShape.isDefined()) {
                domainElementsMapping$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)domainElement), foundAnyShape.get()));
                found = true;
            }
            if (found || !foundShape.isDefined()) break block9;
            domainElementsMapping$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)domainElement), foundShape.get()));
            found = true;
        }
    }

    private CanonicalWebAPITransformer$() {
        MODULE$ = this;
        PlatformSecrets.$init$(this);
        this.CANONICAL_WEBAPI_NAME = "WebAPI 1.0";
    }
}

