/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.api;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.mule.amf.impl.ParserWrapperAmf;
import org.mule.module.apikit.ApikitErrorTypes;
import org.mule.module.apikit.StreamUtils;
import org.mule.module.apikit.api.UrlUtils;
import org.mule.module.apikit.api.exception.MuleRestException;
import org.mule.module.apikit.exception.NotFoundException;
import org.mule.parser.service.ParserService;
import org.mule.raml.interfaces.ParserType;
import org.mule.raml.interfaces.ParserWrapper;
import org.mule.raml.interfaces.common.APISyncUtils;
import org.mule.raml.interfaces.loader.ApiSyncResourceLoader;
import org.mule.raml.interfaces.model.ApiVendor;
import org.mule.raml.interfaces.model.IAction;
import org.mule.raml.interfaces.model.IRaml;
import org.mule.raml.interfaces.model.api.ApiRef;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.TypedException;
import org.raml.model.ActionType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RamlHandler {
    private Pattern CONSOLE_RESOURCE_PATTERN = Pattern.compile(".*console-resources.*(html|json|js)");
    public static final String MULE_APIKIT_PARSER_PROPERTY = "mule.apikit.parser";
    public static final String APPLICATION_RAML = "application/raml+yaml";
    private static final String RAML_QUERY_STRING = "raml";
    private boolean keepApiBaseUri;
    private String apiServer;
    private IRaml api;
    private ParserWrapper parserWrapper;
    private final String rootRamlLocation;
    private String apiResourcesRelativePath = "";
    private ParserType parser;
    protected static final Logger logger = LoggerFactory.getLogger(RamlHandler.class);
    public static final String MULE_APIKIT_PARSER_AMF = "mule.apikit.parser";
    private ErrorTypeRepository errorTypeRepository;
    private List<String> acceptedClasspathResources;

    public RamlHandler(String ramlLocation, boolean keepApiBaseUri) throws IOException {
        this(ramlLocation, keepApiBaseUri, null, null);
    }

    public RamlHandler(String ramlLocation, boolean keepApiBaseUri, ErrorTypeRepository errorTypeRepository) throws IOException {
        this(ramlLocation, keepApiBaseUri, errorTypeRepository, null);
    }

    public RamlHandler(String ramlLocation, boolean keepApiBaseUri, ParserType parserType) throws IOException {
        this(ramlLocation, keepApiBaseUri, null, parserType);
    }

    public RamlHandler(String ramlLocation, boolean keepApiBaseUri, ErrorTypeRepository errorTypeRepository, ParserType parserType) throws IOException {
        this.keepApiBaseUri = keepApiBaseUri;
        this.rootRamlLocation = this.findRootRaml(ramlLocation);
        if (this.rootRamlLocation == null) {
            throw new IOException("Raml not found at: " + ramlLocation);
        }
        this.parserWrapper = new ParserService().getParser(ApiRef.create((String)this.rootRamlLocation), parserType);
        this.parserWrapper.validate();
        this.api = this.parserWrapper.build();
        this.parser = this.parserWrapper.getParserType();
        int idx = this.rootRamlLocation.lastIndexOf("/");
        if (idx > 0) {
            this.apiResourcesRelativePath = this.rootRamlLocation.substring(0, idx + 1);
            this.apiResourcesRelativePath = this.uriPathToResourcePath(this.apiResourcesRelativePath);
        } else if (APISyncUtils.isSyncProtocol((String)this.rootRamlLocation)) {
            this.apiResourcesRelativePath = this.rootRamlLocation;
        }
        this.acceptedClasspathResources = this.getAcceptedClasspathResources(this.api, this.apiResourcesRelativePath);
        this.errorTypeRepository = errorTypeRepository;
    }

    public ParserType getParserType() {
        return this.parser;
    }

    private List<String> getAcceptedClasspathResources(IRaml api, String apiResourcesRelativePath) {
        return api.getAllReferences().stream().map(ref -> {
            int index = ref.indexOf(apiResourcesRelativePath);
            return index > 0 ? ref.substring(index) : ref;
        }).collect(Collectors.toList());
    }

    @Deprecated
    public boolean isParserV2() {
        ParserType parser = this.getParserType();
        return parser == ParserType.AMF || parser == ParserType.RAML && ApiVendor.RAML_10 == this.getApiVendor();
    }

    public ApiVendor getApiVendor() {
        return this.parserWrapper.getApiVendor();
    }

    public IRaml getApi() {
        return this.api;
    }

    public void setApi(IRaml api) {
        this.api = api;
    }

    public String dumpRaml() {
        return this.parserWrapper.dump(this.api, null);
    }

    public String getRamlV1() {
        if (this.keepApiBaseUri) {
            return this.dumpRaml();
        }
        String baseUriReplacement = this.getBaseUriReplacement(this.apiServer);
        return this.parserWrapper.dump(this.api, baseUriReplacement);
    }

    public String getRamlV2(String resourceRelativePath) throws TypedException {
        block10: {
            InputStream apiResource;
            ByteArrayOutputStream baos;
            block9: {
                Object classpathResoruce;
                String resourcePath = this.uriPathToResourcePath(resourceRelativePath);
                Path normalizedPath = Paths.get(resourcePath, new String[0]).normalize();
                if (normalizedPath.getNameCount() < 1) break block10;
                String normalized = normalizedPath.toString();
                if (this.apiResourcesRelativePath.equals(normalized)) {
                    String rootRaml = this.dumpRaml();
                    if (!this.keepApiBaseUri) {
                        String baseUriReplacement = this.getBaseUriReplacement(this.apiServer);
                        return UrlUtils.replaceBaseUri((String)rootRaml, (String)baseUriReplacement);
                    }
                    return rootRaml;
                }
                baos = new ByteArrayOutputStream();
                apiResource = null;
                try {
                    block12: {
                        block13: {
                            block11: {
                                if (!APISyncUtils.isSyncProtocol((String)this.apiResourcesRelativePath)) break block11;
                                ApiSyncResourceLoader loader = new ApiSyncResourceLoader(this.apiResourcesRelativePath);
                                apiResource = loader.getResourceAsStream(normalized.substring(this.apiResourcesRelativePath.length()));
                                break block12;
                            }
                            classpathResoruce = Thread.currentThread().getContextClassLoader().getResource(normalized);
                            if (classpathResoruce == null) break block12;
                            String path = ((URL)classpathResoruce).getPath();
                            if (this.CONSOLE_RESOURCE_PATTERN.asPredicate().test(path)) break block13;
                            if (!this.acceptedClasspathResources.stream().anyMatch(path::endsWith) && !path.endsWith(this.rootRamlLocation)) break block12;
                        }
                        apiResource = ((URL)classpathResoruce).openStream();
                    }
                    if (apiResource == null) break block9;
                    StreamUtils.copyLarge(apiResource, (OutputStream)baos);
                    classpathResoruce = baos.toString();
                }
                catch (IOException e) {
                    try {
                        throw ApikitErrorTypes.throwErrorType((MuleRestException)new NotFoundException(resourceRelativePath), (ErrorTypeRepository)this.errorTypeRepository);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(apiResource);
                        IOUtils.closeQuietly((OutputStream)baos);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)apiResource);
                IOUtils.closeQuietly((OutputStream)baos);
                return classpathResoruce;
            }
            IOUtils.closeQuietly(apiResource);
            IOUtils.closeQuietly((OutputStream)baos);
        }
        throw ApikitErrorTypes.throwErrorType((MuleRestException)new NotFoundException(resourceRelativePath), (ErrorTypeRepository)this.errorTypeRepository);
    }

    public String getAMFModel() {
        if (this.parserWrapper instanceof ParserWrapperAmf) {
            ParserWrapperAmf parserWrapperAmf = (ParserWrapperAmf)this.parserWrapper;
            if (!this.keepApiBaseUri) {
                String baseUriReplacement = this.getBaseUriReplacement(this.apiServer);
                parserWrapperAmf.updateBaseUri(this.api, baseUriReplacement);
            }
            return parserWrapperAmf.getAmfModel();
        }
        return "";
    }

    public String getBaseUriReplacement(String apiServer) {
        return UrlUtils.getBaseUriReplacement((String)apiServer);
    }

    public boolean isRequestingRamlV1ForConsole(String listenerPath, String requestPath, String queryString, String method, String acceptHeader) {
        String postalistenerPath = UrlUtils.getListenerPath((String)listenerPath, (String)requestPath);
        return !(!this.getApiVendor().equals((Object)ApiVendor.RAML_08) || !postalistenerPath.equals(requestPath) && !(postalistenerPath + "/").equals(requestPath) || !ActionType.GET.toString().equals(method.toUpperCase()) || !APPLICATION_RAML.equals(acceptHeader) && !queryString.equals(RAML_QUERY_STRING));
    }

    public boolean isRequestingRamlV2(String listenerPath, String requestPath, String queryString, String method) {
        String consolePath;
        String resourcesFullPath = consolePath = UrlUtils.getListenerPath((String)listenerPath, (String)requestPath);
        if (!consolePath.endsWith("/")) {
            if (!this.apiResourcesRelativePath.startsWith("/")) {
                resourcesFullPath = resourcesFullPath + "/";
            }
            resourcesFullPath = resourcesFullPath + this.apiResourcesRelativePath;
        } else if (this.apiResourcesRelativePath.startsWith("/") && this.apiResourcesRelativePath.length() > 1) {
            resourcesFullPath = resourcesFullPath + this.apiResourcesRelativePath.substring(1);
        }
        return this.getApiVendor().equals((Object)ApiVendor.RAML_10) && queryString.equals(RAML_QUERY_STRING) && ActionType.GET.toString().equals(method.toUpperCase()) && requestPath.startsWith(resourcesFullPath);
    }

    private String uriPathToResourcePath(String resourceRelativePath) {
        if (resourceRelativePath.startsWith("/") && resourceRelativePath.length() > 1) {
            resourceRelativePath = resourceRelativePath.substring(1);
        }
        if (resourceRelativePath.contains("?raml")) {
            resourceRelativePath = resourceRelativePath.substring(0, resourceRelativePath.lastIndexOf(63));
        }
        if (resourceRelativePath.endsWith("/") && resourceRelativePath.length() > 1) {
            resourceRelativePath = resourceRelativePath.substring(0, resourceRelativePath.length() - 1);
        }
        return resourceRelativePath;
    }

    private String findRootRaml(String ramlLocation) {
        try {
            URL url = new URL(ramlLocation);
            return url.toString();
        }
        catch (MalformedURLException e) {
            String[] startingLocations;
            for (String start : startingLocations = new String[]{"api/", "", "api"}) {
                URL ramlLocationUrl = Thread.currentThread().getContextClassLoader().getResource(start + ramlLocation);
                if (ramlLocationUrl == null) continue;
                return start + ramlLocation;
            }
            return null;
        }
    }

    public String getRootRamlLocationForV2() {
        return "this.location.href + '" + this.apiResourcesRelativePath + "/?" + RAML_QUERY_STRING + "'";
    }

    public String getRootRamlLocationForV1() {
        return "this.location.href + '?raml'";
    }

    public String getSuccessStatusCode(IAction action) {
        String status;
        Iterator iterator = action.getResponses().keySet().iterator();
        while (iterator.hasNext() && !"default".equalsIgnoreCase(status = (String)iterator.next())) {
            int code = Integer.parseInt(status);
            if (code < 200 || code >= 300) continue;
            return status;
        }
        return "200";
    }

    public void setApiServer(String apiServer) {
        this.apiServer = apiServer;
    }
}

