/*
 * Decompiled with CFR 0.152.
 */
package amf.core;

import amf.client.plugins.AMFDocumentPlugin;
import amf.client.plugins.AMFFeaturePlugin;
import amf.client.remote.Content;
import amf.core.AMFCompiler$;
import amf.core.Root;
import amf.core.Root$;
import amf.core.benchmark.ExecutionLog$;
import amf.core.client.ParsingOptions;
import amf.core.exception.CyclicReferenceException;
import amf.core.exception.UnsupportedMediaTypeException;
import amf.core.exception.UnsupportedVendorException;
import amf.core.model.document.BaseUnit;
import amf.core.model.document.EncodesModel;
import amf.core.model.document.ExternalFragment;
import amf.core.model.document.ExternalFragment$;
import amf.core.model.domain.ExternalDomainElement;
import amf.core.model.domain.ExternalDomainElement$;
import amf.core.parser.ErrorHandler;
import amf.core.parser.ParsedDocument;
import amf.core.parser.ParsedReference;
import amf.core.parser.ParsedReference$;
import amf.core.parser.ParserContext;
import amf.core.parser.ParserContext$;
import amf.core.parser.RefContainer;
import amf.core.parser.Reference;
import amf.core.parser.ReferenceCollector;
import amf.core.parser.ReferenceHandler;
import amf.core.parser.ReferenceKind;
import amf.core.parser.ReferenceResolutionResult;
import amf.core.registries.AMFPluginsRegistry$;
import amf.core.remote.Cache;
import amf.core.remote.Context;
import amf.core.remote.Context$;
import amf.core.remote.FileMediaType$;
import amf.core.remote.PathResolutionError;
import amf.core.remote.Platform;
import amf.core.remote.Vendor;
import amf.core.utils.package$;
import amf.internal.environment.Environment;
import amf.plugins.features.validation.CoreValidations$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.URISyntaxException;
import org.yaml.model.YNode;
import org.yaml.model.YNode$;
import org.yaml.model.YPart;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001\u0002\u001a4\u0001aB\u0001b\u0010\u0001\u0003\u0006\u0004%\t\u0001\u0011\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0003\"AQ\n\u0001BC\u0002\u0013\u0005a\n\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003P\u0011!)\u0006A!b\u0001\n\u00031\u0006\u0002C/\u0001\u0005\u0003\u0005\u000b\u0011B,\t\u0011y\u0003!Q1A\u0005\u0002}C\u0001\"\u0019\u0001\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tE\u0002\u0011)\u0019!C\u0001?\"A1\r\u0001B\u0001B\u0003%\u0001\r\u0003\u0005e\u0001\t\u0015\r\u0011\"\u0001f\u0011!a\u0007A!A!\u0002\u00131\u0007\u0002C7\u0001\u0005\u000b\u0007I\u0011\u00028\t\u0011I\u0004!\u0011!Q\u0001\n=D\u0001b\u001d\u0001\u0003\u0006\u0004%I\u0001\u001e\u0005\ts\u0002\u0011\t\u0011)A\u0005k\"A!\u0010\u0001BC\u0002\u0013\u00051\u0010C\u0005\u0002\n\u0001\u0011\t\u0011)A\u0005y\"Q\u00111\u0002\u0001\u0003\u0006\u0004%\t!!\u0004\t\u0015\u0005m\u0001A!A!\u0002\u0013\ty\u0001C\u0004\u0002\u001e\u0001!\t!a\b\t\u0011\u0005e\u0002A1A\u0005\u0002\u0001Cq!a\u000f\u0001A\u0003%\u0011\tC\u0005\u0002>\u0001\u0011\r\u0011\"\u0003\u0002@!9\u0011\u0011\t\u0001!\u0002\u0013Q\u0006\u0002CA\"\u0001\t\u0007I\u0011\u0002!\t\u000f\u0005\u0015\u0003\u0001)A\u0005\u0003\"I\u0011q\t\u0001C\u0002\u0013%\u0011\u0011\n\u0005\b\u0003\u0017\u0002\u0001\u0015!\u0003w\u0011\u001d\ti\u0005\u0001C\u0001\u0003\u001fBq!!\u001c\u0001\t\u0013\ty\u0005C\u0004\u0002p\u0001!\t!!\u001d\t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0006bBA^\u0001\u0011%\u0011Q\u0018\u0005\b\u0003w\u0003A\u0011BAb\u0011\u001d\t9\r\u0001C\u0005\u0003\u0013Dq!!9\u0001\t\u0013\t\u0019\u000fC\u0004\u0002h\u0002!I!!;\t\u000f\te\u0001\u0001\"\u0001\u0003\u001c!9\u0011q\u001a\u0001\u0005\u0002\t-ra\u0002B\u0017g!\u0005!q\u0006\u0004\u0007eMB\tA!\r\t\u000f\u0005u1\u0006\"\u0001\u00034!9!QG\u0016\u0005\u0002\t]\u0002\"\u0003B\u001dWE\u0005I\u0011\u0001B\u001e\u0011%\u0011\tfKI\u0001\n\u0003\u0011\u0019\u0006C\u0005\u0003X-\n\n\u0011\"\u0001\u0003Z!I!QL\u0016\u0012\u0002\u0013\u0005!q\f\u0002\f\u0003635i\\7qS2,'O\u0003\u00025k\u0005!1m\u001c:f\u0015\u00051\u0014aA1nM\u000e\u00011C\u0001\u0001:!\tQT(D\u0001<\u0015\u0005a\u0014!B:dC2\f\u0017B\u0001 <\u0005\u0019\te.\u001f*fM\u00061!/Y<Ve2,\u0012!\u0011\t\u0003\u0005&s!aQ$\u0011\u0005\u0011[T\"A#\u000b\u0005\u0019;\u0014A\u0002\u001fs_>$h(\u0003\u0002Iw\u00051\u0001K]3eK\u001aL!AS&\u0003\rM#(/\u001b8h\u0015\tA5(A\u0004sC^,&\u000f\u001c\u0011\u0002\rI,Wn\u001c;f+\u0005y\u0005C\u0001)S\u001b\u0005\t&BA'4\u0013\t\u0019\u0016K\u0001\u0005QY\u0006$hm\u001c:n\u0003\u001d\u0011X-\\8uK\u0002\nAAY1tKV\tq\u000bE\u0002;1jK!!W\u001e\u0003\r=\u0003H/[8o!\t\u00016,\u0003\u0002]#\n91i\u001c8uKb$\u0018!\u00022bg\u0016\u0004\u0013!C7fI&\fG+\u001f9f+\u0005\u0001\u0007c\u0001\u001eY\u0003\u0006QQ.\u001a3jCRK\b/\u001a\u0011\u0002\rY,g\u000eZ8s\u0003\u001d1XM\u001c3pe\u0002\nQB]3gKJ,gnY3LS:$W#\u00014\u0011\u0005\u001dTW\"\u00015\u000b\u0005%\u001c\u0014A\u00029beN,'/\u0003\u0002lQ\ni!+\u001a4fe\u0016t7-Z&j]\u0012\faB]3gKJ,gnY3LS:$\u0007%A\u0003dC\u000eDW-F\u0001p!\t\u0001\u0006/\u0003\u0002r#\n)1)Y2iK\u000611-Y2iK\u0002\n1BY1tK\u000e{g\u000e^3yiV\tQ\u000fE\u0002;1Z\u0004\"aZ<\n\u0005aD'!\u0004)beN,'oQ8oi\u0016DH/\u0001\u0007cCN,7i\u001c8uKb$\b%A\u0002f]Z,\u0012\u0001 \t\u0004{\u0006\u0015Q\"\u0001@\u000b\u0007}\f\t!A\u0006f]ZL'o\u001c8nK:$(bAA\u0002k\u0005A\u0011N\u001c;fe:\fG.C\u0002\u0002\by\u00141\"\u00128wSJ|g.\\3oi\u0006!QM\u001c<!\u00039\u0001\u0018M]:j]\u001e|\u0005\u000f^5p]N,\"!a\u0004\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u00064\u0003\u0019\u0019G.[3oi&!\u0011\u0011DA\n\u00059\u0001\u0016M]:j]\u001e|\u0005\u000f^5p]N\fq\u0002]1sg&twm\u00149uS>t7\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015-\u0005\u0005\u0012QEA\u0014\u0003S\tY#!\f\u00020\u0005E\u00121GA\u001b\u0003o\u00012!a\t\u0001\u001b\u0005\u0019\u0004\"B \u0016\u0001\u0004\t\u0005\"B'\u0016\u0001\u0004y\u0005\"B+\u0016\u0001\u00049\u0006\"\u00020\u0016\u0001\u0004\u0001\u0007\"\u00022\u0016\u0001\u0004\u0001\u0007b\u00023\u0016!\u0003\u0005\rA\u001a\u0005\u0006[V\u0001\ra\u001c\u0005\bgV\u0001\n\u00111\u0001v\u0011\u001dQX\u0003%AA\u0002qD\u0011\"a\u0003\u0016!\u0003\u0005\r!a\u0004\u0002\tA\fG\u000f[\u0001\u0006a\u0006$\b\u000eI\u0001\bG>tG/\u001a=u+\u0005Q\u0016\u0001C2p]R,\u0007\u0010\u001e\u0011\u0002\u00111|7-\u0019;j_:\f\u0011\u0002\\8dCRLwN\u001c\u0011\u0002\u0007\r$\b0F\u0001w\u0003\u0011\u0019G\u000f\u001f\u0011\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0005\u0005E\u0003CBA*\u00033\ni&\u0004\u0002\u0002V)\u0019\u0011qK\u001e\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\\\u0005U#A\u0002$viV\u0014X\r\u0005\u0003\u0002`\u0005%TBAA1\u0015\u0011\t\u0019'!\u001a\u0002\u0011\u0011|7-^7f]RT1!a\u001a4\u0003\u0015iw\u000eZ3m\u0013\u0011\tY'!\u0019\u0003\u0011\t\u000b7/Z+oSR\fqaY8na&dW-\u0001\tbkR|G-\u001a;fGR\u001c\u0016P\u001c;bqR\u0019\u0001-a\u001d\t\u000f\u0005U\u0004\u00051\u0001\u0002x\u000511\u000f\u001e:fC6\u0004B!!\u001f\u0002\u00046\u0011\u00111\u0010\u0006\u0005\u0003{\ny(\u0001\u0003mC:<'BAAA\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00151\u0010\u0002\r\u0007\"\f'oU3rk\u0016t7-Z\u0001\fa\u0006\u00148/Z*z]R\f\u0007\u0010\u0006\u0003\u0002\f\u0006=\u0006\u0003CAG\u0003/\u000bi*!+\u000f\t\u0005=\u00151\u0013\b\u0004\t\u0006E\u0015\"\u0001\u001f\n\u0007\u0005U5(A\u0004qC\u000e\\\u0017mZ3\n\t\u0005e\u00151\u0014\u0002\u0007\u000b&$\b.\u001a:\u000b\u0007\u0005U5\b\u0005\u0003\u0002 \u0006\u0015VBAAQ\u0015\ri\u00151\u0015\u0006\u0004\u0003+)\u0014\u0002BAT\u0003C\u0013qaQ8oi\u0016tG\u000f\u0005\u0003\u0002$\u0005-\u0016bAAWg\t!!k\\8u\u0011\u001d\t\t,\ta\u0001\u0003;\u000bQ!\u001b8qkR\fQ\u0003]1sg\u0016,\u0005\u0010^3s]\u0006dgI]1h[\u0016tG\u000f\u0006\u0003\u0002R\u0005]\u0006bBA]E\u0001\u0007\u0011QT\u0001\bG>tG/\u001a8u\u0003-\u0001\u0018M]:f\t>l\u0017-\u001b8\u0015\t\u0005E\u0013q\u0018\u0005\b\u0003\u0003\u001c\u0003\u0019AAF\u0003\u0019\u0001\u0018M]:fIR!\u0011\u0011KAc\u0011\u001d\t\u0019\u0007\na\u0001\u0003S\u000bq\u0002]1sg\u0016\u0014VMZ3sK:\u001cWm\u001d\u000b\u0007\u0003\u0017\fi-!5\u0011\r\u0005M\u0013\u0011LAU\u0011\u001d\ty-\na\u0001\u0003S\u000bAA]8pi\"9\u00111[\u0013A\u0002\u0005U\u0017\u0001\u00043p[\u0006Lg\u000e\u00157vO&t\u0007\u0003BAl\u0003;l!!!7\u000b\t\u0005m\u00171U\u0001\ba2,x-\u001b8t\u0013\u0011\ty.!7\u0003#\u0005ke\tR8dk6,g\u000e\u001e)mk\u001eLg.A\u0004sKN|GN^3\u0015\u0005\u0005\u0015\bCBA*\u00033\ni*\u0001\u000bwKJLg-_'bi\u000eD\u0017N\\4WK:$wN\u001d\u000b\u0007\u0003W\f\t0!@\u0011\u0007i\ni/C\u0002\u0002pn\u0012A!\u00168ji\"9\u00111_\u0014A\u0002\u0005U\u0018!\u0003:fMZ+g\u000eZ8s!\u0011Q\u0004,a>\u0011\u0007A\u000bI0C\u0002\u0002|F\u0013aAV3oI>\u0014\bbBA\u0000O\u0001\u0007!\u0011A\u0001\u0006]>$Wm\u001d\t\u0007\u0003\u001b\u0013\u0019Aa\u0002\n\t\t\u0015\u00111\u0014\u0002\u0004'\u0016\f\b\u0003\u0002B\u0005\u0005+i!Aa\u0003\u000b\t\u0005\u001d$Q\u0002\u0006\u0005\u0005\u001f\u0011\t\"\u0001\u0003zC6d'B\u0001B\n\u0003\ry'oZ\u0005\u0005\u0005/\u0011YAA\u0003Z\u001d>$W-A\nwKJLg-\u001f,bY&$gI]1h[\u0016tG\u000f\u0006\u0004\u0002l\nu!q\u0004\u0005\b\u0003gD\u0003\u0019AA{\u0011\u001d\u0011\t\u0003\u000ba\u0001\u0005G\tAA]3ggB1\u0011Q\u0012B\u0002\u0005K\u00012a\u001aB\u0014\u0013\r\u0011I\u0003\u001b\u0002\r%\u001647i\u001c8uC&tWM\u001d\u000b\u0003\u0003\u0017\f1\"Q'G\u0007>l\u0007/\u001b7feB\u0019\u00111E\u0016\u0014\u0005-JDC\u0001B\u0018\u0003\u0011Ig.\u001b;\u0015\u0005\u0005-\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$c'\u0006\u0002\u0003>)\u001aaMa\u0010,\u0005\t\u0005\u0003\u0003\u0002B\"\u0005\u001bj!A!\u0012\u000b\t\t\u001d#\u0011J\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0013<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u001f\u0012)EA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012BTC\u0001B+U\r)(qH\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001d\u0016\u0005\tm#f\u0001?\u0003@\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002TC\u0001B1U\u0011\tyAa\u0010")
public class AMFCompiler {
    private final String rawUrl;
    private final Platform remote;
    private final Option<Context> base;
    private final Option<String> mediaType;
    private final Option<String> vendor;
    private final ReferenceKind referenceKind;
    private final Cache cache;
    private final Option<ParserContext> baseContext;
    private final Environment env;
    private final ParsingOptions parsingOptions;
    private final String path;
    private final Context context;
    private final String location;
    private final ParserContext ctx;

    public static ParsingOptions $lessinit$greater$default$10() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$10();
    }

    public static Environment $lessinit$greater$default$9() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$9();
    }

    public static Option<ParserContext> $lessinit$greater$default$8() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$8();
    }

    public static ReferenceKind $lessinit$greater$default$6() {
        return AMFCompiler$.MODULE$.$lessinit$greater$default$6();
    }

    public static void init() {
        AMFCompiler$.MODULE$.init();
    }

    public String rawUrl() {
        return this.rawUrl;
    }

    public Platform remote() {
        return this.remote;
    }

    public Option<Context> base() {
        return this.base;
    }

    public Option<String> mediaType() {
        return this.mediaType;
    }

    public Option<String> vendor() {
        return this.vendor;
    }

    public ReferenceKind referenceKind() {
        return this.referenceKind;
    }

    private Cache cache() {
        return this.cache;
    }

    private Option<ParserContext> baseContext() {
        return this.baseContext;
    }

    public Environment env() {
        return this.env;
    }

    public ParsingOptions parsingOptions() {
        return this.parsingOptions;
    }

    public String path() {
        return this.path;
    }

    private Context context() {
        return this.context;
    }

    private String location() {
        return this.location;
    }

    private ParserContext ctx() {
        return this.ctx;
    }

    public Future<BaseUnit> build() {
        ExecutionLog$.MODULE$.log(new StringBuilder(28).append("AMFCompiler#build: Building ").append(this.rawUrl()).toString());
        return this.context().hasCycles() ? Future$.MODULE$.failed((Throwable)new CyclicReferenceException(this.context().history())) : this.cache().getOrUpdate(this.location(), this.context(), (Function0<Future<BaseUnit>>)(Function0 & Serializable & scala.Serializable)() -> {
            ExecutionLog$.MODULE$.log(new StringBuilder(29).append("AMFCompiler#build: compiling ").append(this.rawUrl()).toString());
            return this.compile();
        });
    }

    private Future<BaseUnit> compile() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)input -> this.parseSyntax((Content)input), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)parsed -> this.parseDomain((Either<Content, Root>)parsed), ExecutionContext.Implicits$.MODULE$.global());
    }

    public Option<String> autodetectSyntax(CharSequence stream) {
        Option option;
        if (stream.length() > 2 && stream.charAt(0) == '#' && stream.charAt(1) == '%') {
            ExecutionLog$.MODULE$.log("AMFCompiler#autodetectSyntax: auto detected application/yaml media type");
            option = new Some((Object)"application/yaml");
        } else {
            option = this.base().flatMap((Function1 & Serializable & scala.Serializable)b -> {
                None$ none$;
                Some some;
                char c2;
                Option<Object> option = b.platform().findCharInCharSequence(stream, (Function1<Object, Object>)(Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean((boolean)AMFCompiler.$anonfun$autodetectSyntax$2(BoxesRunTime.unboxToChar((Object)c))));
                if (option instanceof Some && ((c2 = BoxesRunTime.unboxToChar((Object)(some = (Some)option).value())) == '{' || c2 == '[')) {
                    ExecutionLog$.MODULE$.log("AMFCompiler#autodetectSyntax: auto detected application/json media type");
                    none$ = new Some((Object)"application/json");
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            });
        }
        return option;
    }

    private Either<Content, Root> parseSyntax(Content input) {
        Left left;
        Some some;
        Tuple2 tuple2;
        Option parsed;
        ExecutionLog$.MODULE$.log(new StringBuilder(40).append("AMFCompiler#parseSyntax: parsing syntax ").append(this.rawUrl()).toString());
        Content content = (Content)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft((Object)input, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Content c = (Content)tuple2._1();
            AMFFeaturePlugin p = (AMFFeaturePlugin)tuple2._2();
            Content content = p.onBeginDocumentParsing(this.path(), c, this.referenceKind());
            return content;
        });
        Option option = parsed = this.mediaType().flatMap((Function1 & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> x$2.parse((String)mime, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$3 -> new Tuple2(mime, x$3))).orElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<String> option = this.mediaType();
            Object object = None$.MODULE$.equals(option) ? content.mime().flatMap((Function1 & Serializable & scala.Serializable)mime -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)mime).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.parse((String)mime, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$5 -> new Tuple2(mime, x$5))).orElse((Function0 & Serializable & scala.Serializable)() -> FileMediaType$.MODULE$.extension(content.url()).flatMap((Function1 & Serializable & scala.Serializable)extension -> FileMediaType$.MODULE$.mimeFromExtension((String)extension)).flatMap((Function1 & Serializable & scala.Serializable)infered -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)infered).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.parse((String)infered, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$7 -> new Tuple2(infered, x$7)))).orElse((Function0 & Serializable & scala.Serializable)() -> this.autodetectSyntax(content.stream()).flatMap((Function1 & Serializable & scala.Serializable)infered -> AMFPluginsRegistry$.MODULE$.syntaxPluginForMediaType((String)infered).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.parse((String)infered, content.stream(), this.ctx(), this.parsingOptions())).map((Function1 & Serializable & scala.Serializable)x$9 -> new Tuple2(infered, x$9)))) : None$.MODULE$;
            return object;
        });
        if (option instanceof Some && (tuple2 = (Tuple2)(some = (Some)option).value()) != null) {
            String effective = (String)tuple2._1();
            ParsedDocument document = (ParsedDocument)tuple2._2();
            ParsedDocument doc = (ParsedDocument)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft((Object)document, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$2);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ParsedDocument d = (ParsedDocument)tuple2._1();
                AMFFeaturePlugin p = (AMFFeaturePlugin)tuple2._2();
                ParsedDocument parsedDocument = p.onSyntaxParsed(this.path(), d);
                return parsedDocument;
            });
            left = scala.package$.MODULE$.Right().apply((Object)Root$.MODULE$.apply(doc, content.url(), effective, (Seq<ParsedReference>)((Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$)), this.referenceKind(), content.stream().toString()));
        } else if (None$.MODULE$.equals(option)) {
            left = scala.package$.MODULE$.Left().apply((Object)content);
        } else {
            throw new MatchError((Object)option);
        }
        return left;
    }

    public Future<BaseUnit> parseExternalFragment(Content content) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ExternalDomainElement result = ((ExternalDomainElement)ExternalDomainElement$.MODULE$.apply().withId(new StringBuilder(2).append(content.url()).append("#/").toString())).withRaw(content.stream().toString());
            content.mime().foreach((Function1 & Serializable & scala.Serializable)mime -> result.withMediaType((String)mime));
            return (ExternalFragment)((BaseUnit)((Object)((EncodesModel)ExternalFragment$.MODULE$.apply().withLocation(content.url()).withId(content.url())).withEncodes(result))).withLocation(content.url());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<BaseUnit> parseDomain(Either<Content, Root> parsed) {
        Future<BaseUnit> future;
        Either<Content, Root> either = parsed;
        if (either instanceof Left) {
            Left left = (Left)either;
            Content content = (Content)left.value();
            Option<String> option = this.mediaType();
            if (option instanceof Some) {
                Some some = (Some)option;
                String mime = (String)some.value();
                if (this.context().history().length() == 1) {
                    throw new UnsupportedMediaTypeException(mime);
                }
            }
            Future<BaseUnit> future2 = this.parseExternalFragment(content);
            future = future2;
        } else if (either instanceof Right) {
            Right right = (Right)either;
            Root document = (Root)right.value();
            future = this.parseDomain(document);
        } else {
            throw new MatchError(either);
        }
        return future;
    }

    private Future<BaseUnit> parseDomain(Root document) {
        Future future;
        ExecutionLog$.MODULE$.log(new StringBuilder(40).append("AMFCompiler#parseDomain: parsing domain ").append(this.rawUrl()).toString());
        int currentRun = this.ctx().parserCount();
        Option domainPluginOption = (Option)this.vendor().fold((Function0 & Serializable & scala.Serializable)() -> AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(document.mediatype()).find((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)x$10.canParse(document))), (Function1 & Serializable & scala.Serializable)x$11 -> AMFPluginsRegistry$.MODULE$.documentPluginForVendor((String)x$11).find((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x$12.canParse(document))));
        boolean bl = false;
        Option option = null;
        Option option2 = domainPluginOption;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
            ExecutionLog$.MODULE$.log(new StringBuilder(48).append("AMFCompiler#parseSyntax: parsing domain ").append(this.rawUrl()).append(" plugin ").append(domainPlugin.ID()).toString());
            future = this.parseReferences(document, domainPlugin).map((Function1 & Serializable & scala.Serializable)documentWithReferences -> {
                BaseUnit baseUnit;
                ParserContext newCtx = this.ctx().copyWithSonsReferences();
                Option<BaseUnit> option = domainPlugin.parse((Root)documentWithReferences, newCtx, this.remote(), this.parsingOptions());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BaseUnit baseUnit2 = (BaseUnit)some.value();
                    baseUnit = baseUnit2.withRaw(document.raw());
                } else if (None$.MODULE$.equals(option)) {
                    baseUnit = (BaseUnit)((Object)((EncodesModel)((Object)((BaseUnit)ExternalFragment$.MODULE$.apply().withId(document.location())).withLocation(document.location()))).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype())));
                } else {
                    throw new MatchError(option);
                }
                return baseUnit;
            }, ExecutionContext.Implicits$.MODULE$.global());
        } else {
            if (None$.MODULE$.equals(option2)) {
                bl = true;
                option = option2;
                if (this.vendor().isDefined()) {
                    throw new UnsupportedVendorException((String)this.vendor().get());
                }
            }
            if (bl) {
                future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    ExecutionLog$.MODULE$.log(new StringBuilder(50).append("AMFCompiler#parseSyntax: parsing domain ").append(this.rawUrl()).append(" NO PLUGIN").toString());
                    return (ExternalFragment)((EncodesModel)ExternalFragment$.MODULE$.apply().withLocation(document.location()).withId(document.location())).withEncodes(ExternalDomainElement$.MODULE$.apply().withRaw(document.raw()).withMediaType(document.mediatype()));
                }, ExecutionContext.Implicits$.MODULE$.global());
            } else {
                throw new MatchError((Object)option2);
            }
        }
        Future futureDocument = future;
        return futureDocument.map((Function1 & Serializable & scala.Serializable)baseUnit -> {
            baseUnit.parserRun_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)currentRun)));
            ExecutionLog$.MODULE$.log(new StringBuilder(37).append("AMFCompiler#parseDomain: model ready ").append(this.rawUrl()).toString());
            BaseUnit bu = (BaseUnit)AMFPluginsRegistry$.MODULE$.featurePlugins().foldLeft(baseUnit, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                BaseUnit unit = (BaseUnit)tuple2._1();
                AMFFeaturePlugin plugin = (AMFFeaturePlugin)tuple2._2();
                BaseUnit baseUnit = plugin.onModelParsed(this.path(), unit);
                return baseUnit;
            });
            return baseUnit;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Root> parseReferences(Root root, AMFDocumentPlugin domainPlugin) {
        ReferenceHandler handler = domainPlugin.referenceHandler(this.ctx());
        ReferenceCollector refs = handler.collect(root.parsed(), this.ctx());
        ExecutionLog$.MODULE$.log(new StringBuilder(50).append("AMFCompiler#parseReferences: ").append(refs.toReferences().size()).append(" references found in ").append(this.rawUrl()).toString());
        Seq parsed = (Seq)((TraversableLike)refs.toReferences().filter((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToBoolean((boolean)x$13.isRemote()))).map((Function1 & Serializable & scala.Serializable)link -> {
            Seq nodes = (Seq)link.refs().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.node(), Seq$.MODULE$.canBuildFrom());
            return link.resolve(this.context(), this.cache(), this.ctx(), this.env(), (Seq<YNode>)nodes, domainPlugin.allowRecursiveReferences()).flatMap(arg_0 -> AMFCompiler.$anonfun$parseReferences$4(this, nodes, link, handler, domainPlugin, arg_0), ExecutionContext.Implicits$.MODULE$.global());
        }, Seq$.MODULE$.canBuildFrom());
        return Future$.MODULE$.sequence((TraversableOnce)parsed, Seq$.MODULE$.canBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)rs -> {
            Seq x$1 = (Seq)rs.flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
            ParsedDocument x$2 = root.copy$default$1();
            String x$3 = root.copy$default$2();
            String x$4 = root.copy$default$3();
            ReferenceKind x$5 = root.copy$default$5();
            String x$6 = root.copy$default$6();
            return root.copy(x$2, x$3, x$4, (Seq<ParsedReference>)x$1, x$5, x$6);
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Future<Content> resolve() {
        return this.remote().resolve(this.location(), this.env());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyMatchingVendor(Option<Vendor> refVendor, Seq<YNode> nodes) {
        Option<Vendor> option = refVendor;
        if (option instanceof Some) {
            Some some = (Some)option;
            Vendor v = (Vendor)some.value();
            if (this.vendor().nonEmpty() && !v.name().contains((CharSequence)this.vendor().get())) {
                nodes.foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
                    AMFCompiler.$anonfun$verifyMatchingVendor$1(this, x$16);
                    return BoxedUnit.UNIT;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public void verifyValidFragment(Option<Vendor> refVendor, Seq<RefContainer> refs) {
        Some some;
        Vendor v;
        Option<Vendor> option = refVendor;
        if (option instanceof Some && (v = (Vendor)(some = (Some)option).value()).isRaml()) {
            refs.foreach((Function1 & Serializable & scala.Serializable)r -> {
                AMFCompiler.$anonfun$verifyValidFragment$1(this, r);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Future<Root> root() {
        return this.resolve().map((Function1 & Serializable & scala.Serializable)input -> this.parseSyntax((Content)input), ExecutionContext.Implicits$.MODULE$.global()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Right right;
            Root document;
            Either either = x0$1;
            if (either instanceof Right && (document = (Root)(right = (Right)either).value()) != null) {
                Future future;
                Root root = document;
                Option option = AMFPluginsRegistry$.MODULE$.documentPluginForMediaType(root.mediatype()).find((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.canParse(root)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    AMFDocumentPlugin domainPlugin = (AMFDocumentPlugin)some.value();
                    future = this.parseReferences(root, domainPlugin);
                    return future;
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    future = Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> root, ExecutionContext.Implicits$.MODULE$.global());
                }
                return future;
            }
            if (!(either instanceof Left)) throw new MatchError((Object)either);
            Left left = (Left)either;
            Content content = (Content)left.value();
            throw new Exception(new StringBuilder(37).append("Cannot parse document with mime type ").append(content.mime().getOrElse((Function0 & Serializable & scala.Serializable)() -> "none")).toString());
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private final String liftedTree1$1() {
        String string;
        try {
            string = package$.MODULE$.Strings(this.rawUrl()).normalizePath();
        }
        catch (URISyntaxException e) {
            ((ErrorHandler)this.baseContext().getOrElse((Function0 & Serializable & scala.Serializable)() -> new ParserContext(this.rawUrl(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3(), ParserContext$.MODULE$.apply$default$4(), ParserContext$.MODULE$.apply$default$5()))).violation(CoreValidations$.MODULE$.UriSyntaxError(), this.path(), e.getMessage(), (YPart)YNode$.MODULE$.apply(this.path()));
            string = this.rawUrl();
        }
        catch (Exception e) {
            throw new PathResolutionError(e.getMessage());
        }
        return string;
    }

    public static final /* synthetic */ Context $anonfun$context$1(AMFCompiler $this, Context x$1) {
        return x$1.update($this.path());
    }

    public static final /* synthetic */ Context $anonfun$context$2(AMFCompiler $this) {
        return Context$.MODULE$.apply($this.remote(), $this.path());
    }

    public static final /* synthetic */ boolean $anonfun$autodetectSyntax$2(char c) {
        return c != '\n' && c != '\t' && c != '\r' && c != ' ';
    }

    public static final /* synthetic */ Some $anonfun$parseReferences$5(ParsedReference x$15) {
        return new Some((Object)x$15);
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$6() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$parseReferences$7(AMFCompiler $this, Reference link$1, Throwable e$1, YNode ref) {
        $this.ctx().violation(CoreValidations$.MODULE$.UnresolvedReference(), link$1.url(), e$1.getMessage(), (YPart)ref);
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$8() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ None$ $anonfun$parseReferences$9() {
        return None$.MODULE$;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ Future $anonfun$parseReferences$4(AMFCompiler $this, Seq nodes$1, Reference link$1, ReferenceHandler handler$1, AMFDocumentPlugin domainPlugin$2, ReferenceResolutionResult x0$1) {
        block4: {
            block5: {
                block3: {
                    var8_6 = x0$1;
                    if (var8_6 == null || !((var9_7 = var8_6.unit()) instanceof Some)) break block3;
                    var10_8 = (Some)var9_7;
                    unit = (BaseUnit)var10_8.value();
                    $this.verifyMatchingVendor(unit.sourceVendor(), (Seq<YNode>)nodes$1);
                    $this.verifyValidFragment(unit.sourceVendor(), link$1.refs());
                    reference = new ParsedReference(unit, link$1, ParsedReference$.MODULE$.apply$default$3());
                    var6_11 = handler$1.update(reference, $this.ctx(), $this.context(), $this.env(), $this.cache()).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseReferences$5(amf.core.parser.ParsedReference ), (Lamf/core/parser/ParsedReference;)Lscala/Some;)(), ExecutionContext.Implicits$.MODULE$.global());
                    break block4;
                }
                if (var8_6 == null || !((var13_12 = var8_6.exception()) instanceof Some)) break block5;
                var14_13 = (Some)var13_12;
                e = (Throwable)var14_13.value();
                var16_15 = e;
                if (!(var16_15 instanceof CyclicReferenceException)) ** GOTO lbl-1000
                var17_16 = (CyclicReferenceException)var16_15;
                if (!domainPlugin$2.allowRecursiveReferences()) {
                    $this.ctx().violation(CoreValidations$.MODULE$.CycleReferenceError(), link$1.url(), var17_16.getMessage(), (YPart)((RefContainer)link$1.refs().head()).node());
                    var7_17 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$6(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
                } else lbl-1000:
                // 2 sources

                {
                    if (!link$1.isInferred()) {
                        nodes$1.foreach((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$parseReferences$7$adapted(amf.core.AMFCompiler amf.core.parser.Reference java.lang.Throwable org.yaml.model.YNode ), (Lorg/yaml/model/YNode;)Ljava/lang/Object;)((AMFCompiler)$this, (Reference)link$1, (Throwable)e));
                    }
                    var7_17 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$8(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
                }
                var6_11 = var7_17;
                break block4;
            }
            var6_11 = Future$.MODULE$.apply((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$parseReferences$9(), ()Lscala/None$;)(), ExecutionContext.Implicits$.MODULE$.global());
        }
        return var6_11;
    }

    public static final /* synthetic */ void $anonfun$verifyMatchingVendor$1(AMFCompiler $this, YNode x$16) {
        $this.ctx().violation(CoreValidations$.MODULE$.InvalidCrossSpec(), "", "Cannot reference fragments of another spec", (YPart)x$16);
    }

    public static final /* synthetic */ void $anonfun$verifyValidFragment$1(AMFCompiler $this, RefContainer r) {
        block0: {
            if (!r.fragment().isDefined()) break block0;
            $this.ctx().violation(CoreValidations$.MODULE$.InvalidFragmentRef(), "", "Cannot use reference with # in a RAML fragment", (YPart)r.node());
        }
    }

    /*
     * Unable to fully structure code
     */
    public AMFCompiler(String rawUrl, Platform remote, Option<Context> base, Option<String> mediaType, Option<String> vendor, ReferenceKind referenceKind, Cache cache, Option<ParserContext> baseContext, Environment env, ParsingOptions parsingOptions) {
        this.rawUrl = rawUrl;
        this.remote = remote;
        this.base = base;
        this.mediaType = mediaType;
        this.vendor = vendor;
        this.referenceKind = referenceKind;
        this.cache = cache;
        this.baseContext = baseContext;
        this.env = env;
        this.parsingOptions = parsingOptions;
        super();
        this.path = this.liftedTree1$1();
        this.context = (Context)base.map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$context$1(amf.core.AMFCompiler amf.core.remote.Context ), (Lamf/core/remote/Context;)Lamf/core/remote/Context;)((AMFCompiler)this)).getOrElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$context$2(amf.core.AMFCompiler ), ()Lamf/core/remote/Context;)((AMFCompiler)this));
        this.location = this.context().current();
        var12_11 = false;
        var13_12 = null;
        var14_13 = baseContext;
        if (!(var14_13 instanceof Some)) ** GOTO lbl-1000
        var12_11 = true;
        var13_12 = (Some)var14_13;
        given = (ParserContext)var13_12.value();
        if (given.rootContextDocument().equals(this.location())) {
            var11_15 = given;
        } else if (var12_11) {
            given = (ParserContext)var13_12.value();
            var11_15 = given.forLocation(this.location());
        } else if (None$.MODULE$.equals(var14_13)) {
            var11_15 = new ParserContext(this.location(), ParserContext$.MODULE$.apply$default$2(), ParserContext$.MODULE$.apply$default$3(), ParserContext$.MODULE$.apply$default$4(), ParserContext$.MODULE$.apply$default$5());
        } else {
            throw new MatchError(var14_13);
        }
        this.ctx = var11_15;
    }

    public static final /* synthetic */ Object $anonfun$parseReferences$7$adapted(AMFCompiler $this, Reference link$1, Throwable e$1, YNode ref) {
        AMFCompiler.$anonfun$parseReferences$7($this, link$1, e$1, ref);
        return BoxedUnit.UNIT;
    }
}

