/*
 * Decompiled with CFR 0.152.
 */
package amf.plugins.features.validation;

import amf.AmfProfile$;
import amf.core.benchmark.ExecutionLog$;
import amf.core.emitter.RenderOptions;
import amf.core.model.document.BaseUnit;
import amf.core.rdf.RdfFramework;
import amf.core.rdf.RdfModel;
import amf.core.rdf.RdfModelDocument;
import amf.core.rdf.RdfModelEmitter;
import amf.core.services.ValidationOptions;
import amf.core.validation.core.ValidationReport;
import amf.core.validation.core.ValidationSpecification;
import amf.plugins.features.validation.CachedScriptEngine;
import amf.plugins.features.validation.JVMValidationReport;
import amf.plugins.features.validation.JenaRdfModel;
import amf.plugins.features.validation.JenaRdfModel$;
import amf.plugins.features.validation.RDFPrinter$;
import amf.plugins.features.validation.SHACL$;
import amf.plugins.features.validation.emitters.ValidationRdfModelEmitter;
import amf.plugins.features.validation.emitters.ValidationRdfModelEmitter$;
import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.mulesoft.common.io.Output;
import org.topbraid.jenax.util.JenaUtil;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.JSScriptEngineFactory;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001B\n\u0015\u0001uAQa\u000b\u0001\u0005\u00021Bqa\f\u0001A\u0002\u0013\u0005\u0001\u0007C\u0004@\u0001\u0001\u0007I\u0011\u0001!\t\r\u0019\u0003\u0001\u0015)\u00032\u0011\u001d9\u0005\u00011A\u0005\u0002ABq\u0001\u0013\u0001A\u0002\u0013\u0005\u0011\n\u0003\u0004L\u0001\u0001\u0006K!\r\u0005\b\u0019\u0002\u0011\r\u0011\"\u0001N\u0011\u0019i\u0006\u0001)A\u0005\u001d\")a\f\u0001C!?\")a\u000e\u0001C\u0005_\"9\u00111\u0001\u0001\u0005B\u0005\u0015\u0001bBA\f\u0001\u0011\u0005\u0013\u0011\u0004\u0005\b\u0003G\u0001A\u0011CA\u0013\u0011\u0019q\u0006\u0001\"\u0011\u0002(!9\u00111\u0001\u0001\u0005B\u0005\r\u0004BB6\u0001\t\u0003\nY\u0007C\u0004\u0002~\u0001!\t%a \u0003\u001dMC\u0015i\u0011'WC2LG-\u0019;pe*\u0011QCF\u0001\u000bm\u0006d\u0017\u000eZ1uS>t'BA\f\u0019\u0003!1W-\u0019;ve\u0016\u001c(BA\r\u001b\u0003\u001d\u0001H.^4j]NT\u0011aG\u0001\u0004C647\u0001A\n\u0004\u0001y!\u0003CA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#AB!osJ+g\r\u0005\u0002&U5\taE\u0003\u0002(Q\u0005!1m\u001c:f\u0015\t)\u0012F\u0003\u0002(5%\u00111CJ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"A\f\u0001\u000e\u0003Q\t1BZ;oGRLwN\\+sYV\t\u0011\u0007E\u0002 eQJ!a\r\u0011\u0003\r=\u0003H/[8o!\t)DH\u0004\u00027uA\u0011q\u0007I\u0007\u0002q)\u0011\u0011\bH\u0001\u0007yI|w\u000e\u001e \n\u0005m\u0002\u0013A\u0002)sK\u0012,g-\u0003\u0002>}\t11\u000b\u001e:j]\u001eT!a\u000f\u0011\u0002\u001f\u0019,hn\u0019;j_:,&\u000f\\0%KF$\"!\u0011#\u0011\u0005}\u0011\u0015BA\"!\u0005\u0011)f.\u001b;\t\u000f\u0015\u001b\u0011\u0011!a\u0001c\u0005\u0019\u0001\u0010J\u0019\u0002\u0019\u0019,hn\u0019;j_:,&\u000f\u001c\u0011\u0002\u0019\u0019,hn\u0019;j_:\u001cu\u000eZ3\u0002!\u0019,hn\u0019;j_:\u001cu\u000eZ3`I\u0015\fHCA!K\u0011\u001d)e!!AA\u0002E\nQBZ;oGRLwN\\\"pI\u0016\u0004\u0013a\u00024pe6\fGo]\u000b\u0002\u001dB!q\n\u0016,W\u001b\u0005\u0001&BA)S\u0003%IW.\\;uC\ndWM\u0003\u0002TA\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005U\u0003&aA'baB\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\u0005Y\u0006twMC\u0001\\\u0003\u0011Q\u0017M^1\n\u0005uB\u0016\u0001\u00034pe6\fGo\u001d\u0011\u0002\u0011Y\fG.\u001b3bi\u0016$R\u0001\u00194iU2\u00042!\u001935\u001b\u0005\u0011'BA2!\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003K\n\u0014aAR;ukJ,\u0007\"B4\u000b\u0001\u0004!\u0014\u0001\u00023bi\u0006DQ!\u001b\u0006A\u0002Q\nQ\u0002Z1uC6+G-[1UsB,\u0007\"B6\u000b\u0001\u0004!\u0014AB:iCB,7\u000fC\u0003n\u0015\u0001\u0007A'A\btQ\u0006\u0004Xm]'fI&\fG+\u001f9f\u0003%aw.\u00193N_\u0012,G\u000eF\u0002q}~\u0004\"!\u001d?\u000e\u0003IT!a\u001d;\u0002\u000b5|G-\u001a7\u000b\u0005U4\u0018a\u0001:eM*\u0011q\u000f_\u0001\u0005U\u0016t\u0017M\u0003\u0002zu\u00061\u0011\r]1dQ\u0016T\u0011a_\u0001\u0004_J<\u0017BA?s\u0005\u0015iu\u000eZ3m\u0011\u001597\u00021\u00015\u0011\u0019\t\ta\u0003a\u0001i\u0005IQ.\u001a3jCRK\b/Z\u0001\u0007e\u0016\u0004xN\u001d;\u0015\u0015\u0005\u001d\u0011qBA\t\u0003'\t)\u0002\u0005\u0003bI\u0006%\u0001cA\u0013\u0002\f%\u0019\u0011Q\u0002\u0014\u0003!Y\u000bG.\u001b3bi&|gNU3q_J$\b\"B4\r\u0001\u0004!\u0004\"B5\r\u0001\u0004!\u0004\"B6\r\u0001\u0004!\u0004\"B7\r\u0001\u0004!\u0014a\u0004:fO&\u001cH/\u001a:MS\n\u0014\u0018M]=\u0015\u000b\u0005\u000bY\"a\b\t\r\u0005uQ\u00021\u00015\u0003\r)(\u000f\u001c\u0005\u0007\u0003Ci\u0001\u0019\u0001\u001b\u0002\t\r|G-Z\u0001\fY>\fG\rT5ce\u0006\u0014\u0018\u0010F\u0001B)\u001d\u0001\u0017\u0011FA\u001d\u0003'BaaZ\bA\u0002\u0005-\u0002\u0003BA\u0017\u0003ki!!a\f\u000b\t\u0005E\u00121G\u0001\tI>\u001cW/\\3oi*\u00111/K\u0005\u0005\u0003o\tyC\u0001\u0005CCN,WK\\5u\u0011\u0019Yw\u00021\u0001\u0002<A1\u0011QHA$\u0003\u001brA!a\u0010\u0002D9\u0019q'!\u0011\n\u0003\u0005J1!!\u0012!\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0013\u0002L\t\u00191+Z9\u000b\u0007\u0005\u0015\u0003\u0005E\u0002&\u0003\u001fJ1!!\u0015'\u0005]1\u0016\r\\5eCRLwN\\*qK\u000eLg-[2bi&|g\u000eC\u0004\u0002V=\u0001\r!a\u0016\u0002\u000f=\u0004H/[8ogB!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^%\n\u0001b]3sm&\u001cWm]\u0005\u0005\u0003C\nYFA\tWC2LG-\u0019;j_:|\u0005\u000f^5p]N$\u0002\"a\u0002\u0002f\u0005\u001d\u0014\u0011\u000e\u0005\u0007OB\u0001\r!a\u000b\t\r-\u0004\u0002\u0019AA\u001e\u0011\u001d\t)\u0006\u0005a\u0001\u0003/\"b!!\u001c\u0002x\u0005e\u0004\u0003BA8\u0003gj!!!\u001d\u000b\u0005UL\u0013\u0002BA;\u0003c\u0012\u0001B\u00153g\u001b>$W\r\u001c\u0005\u0007WF\u0001\r!a\u000f\t\r\u0005m\u0014\u00031\u00015\u000311WO\\2uS>t7/\u0016:m\u00035)W\u000e\u001d;z%\u00124Wj\u001c3fYR\u0011\u0011Q\u000e")
public class SHACLValidator
implements amf.core.validation.core.SHACLValidator {
    private Option<String> functionUrl;
    private Option<String> functionCode;
    private final Map<String, String> formats;

    @Override
    public RdfModel unitToRdfModel(BaseUnit unit, RenderOptions options) {
        return RdfFramework.unitToRdfModel$(this, unit, options);
    }

    @Override
    public Option<RdfModelDocument> syntaxToRdfModel(String mediaType, CharSequence text) {
        return RdfFramework.syntaxToRdfModel$(this, mediaType, text);
    }

    @Override
    public Option<String> rdfModelToSyntax(String mediaType, RdfModelDocument rdfModelDocument) {
        return RdfFramework.rdfModelToSyntax$(this, mediaType, rdfModelDocument);
    }

    @Override
    public <W> Option<W> rdfModelToSyntaxWriter(String mediaType, RdfModelDocument rdfModelDocument, W writer, Output<W> evidence$1) {
        return RdfFramework.rdfModelToSyntaxWriter$(this, mediaType, rdfModelDocument, writer, evidence$1);
    }

    public Option<String> functionUrl() {
        return this.functionUrl;
    }

    public void functionUrl_$eq(Option<String> x$1) {
        this.functionUrl = x$1;
    }

    public Option<String> functionCode() {
        return this.functionCode;
    }

    public void functionCode_$eq(Option<String> x$1) {
        this.functionCode = x$1;
    }

    public Map<String, String> formats() {
        return this.formats;
    }

    @Override
    public Future<String> validate(String data, String dataMediaType, String shapes, String shapesMediaType) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Model dataModel = this.loadModel(StringUtils.chomp((String)data), dataMediaType);
            Model shapesModel = this.loadModel(StringUtils.chomp((String)shapes), shapesMediaType);
            this.loadLibrary();
            boolean res = SHACLScriptEngineManager.begin();
            None$ report = None$.MODULE$;
            try {
                SHACLScriptEngineManager.getCurrentEngine().executeScriptFromURL("http://datashapes.org/js/rdfquery.js");
                report = new Some((Object)SHACL$.MODULE$.validate(dataModel, shapesModel));
            }
            finally {
                SHACLScriptEngineManager.end((boolean)res);
            }
            return RDFPrinter$.MODULE$.apply(((RDFNode)report.get()).getModel(), "JSON-LD");
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    private Model loadModel(String data, String mediaType) {
        Option option = this.formats().get((Object)mediaType);
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception(new StringBuilder(23).append("Unsupported media type ").append(mediaType).toString());
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        String format = (String)some.value();
        Model dataModel = JenaUtil.createMemoryModel();
        dataModel.read(IOUtils.toInputStream((String)data, (Charset)Charset.defaultCharset()), "urn:dummy", format);
        Model model = dataModel;
        return model;
    }

    @Override
    public Future<ValidationReport> report(String data, String dataMediaType, String shapes, String shapesMediaType) {
        return this.validate(data, dataMediaType, shapes, shapesMediaType).map((Function1 & Serializable & scala.Serializable)x$1 -> new JVMValidationReport((String)x$1), ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public void registerLibrary(String url, String code) {
        this.functionUrl_$eq((Option<String>)new Some((Object)url));
        this.functionCode_$eq((Option<String>)new Some((Object)code));
    }

    public void loadLibrary() {
        JSScriptEngineFactory.set((JSScriptEngineFactory)new JSScriptEngineFactory(this){
            private final /* synthetic */ SHACLValidator $outer;

            public JSScriptEngine createScriptEngine() {
                return new CachedScriptEngine(this.$outer.functionUrl(), this.$outer.functionCode());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Override
    public Future<String> validate(BaseUnit data, Seq<ValidationSpecification> shapes, ValidationOptions options) {
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading Jena data model");
            JenaRdfModel dataModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
            new RdfModelEmitter(dataModel).emit(data, options.toRenderOptions());
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading Jena shapes model");
            JenaRdfModel shapesModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
            new ValidationRdfModelEmitter(options.messageStyle().profileName(), shapesModel, ValidationRdfModelEmitter$.MODULE$.$lessinit$greater$default$3()).emit(shapes);
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: loading library");
            this.loadLibrary();
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: starting script engine");
            boolean res = SHACLScriptEngineManager.begin();
            None$ report = None$.MODULE$;
            try {
                SHACLScriptEngineManager.getCurrentEngine().executeScriptFromURL("http://datashapes.org/js/rdfquery.js");
                ExecutionLog$.MODULE$.log(new StringBuilder(51).append("SHACLValidator#validate: Number of data triples -> ").append(dataModel.model().listStatements().toList().size()).toString());
                ExecutionLog$.MODULE$.log(new StringBuilder(53).append("SHACLValidator#validate: Number of shapes triples -> ").append(shapesModel.model().listStatements().toList().size()).toString());
                ExecutionLog$.MODULE$.log("SHACLValidator#validate: validating...");
                report = new Some((Object)SHACL$.MODULE$.validate(dataModel.model(), shapesModel.model()));
            }
            finally {
                ExecutionLog$.MODULE$.log("SHACLValidator#validate: releasing script manager resources");
                SHACLScriptEngineManager.end((boolean)res);
            }
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: Generating JSON-LD report");
            String output = RDFPrinter$.MODULE$.apply(((RDFNode)report.get()).getModel(), "JSON-LD");
            ExecutionLog$.MODULE$.log("SHACLValidator#validate: finishing");
            return output;
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    @Override
    public Future<ValidationReport> report(BaseUnit data, Seq<ValidationSpecification> shapes, ValidationOptions options) {
        return this.validate(data, shapes, options).map((Function1 & Serializable & scala.Serializable)x$2 -> new JVMValidationReport((String)x$2), ExecutionContext.Implicits$.MODULE$.global());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public RdfModel shapes(Seq<ValidationSpecification> shapes, String functionsUrl) {
        void var3_3;
        JenaRdfModel shapesModel = new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
        new ValidationRdfModelEmitter(AmfProfile$.MODULE$, shapesModel, ValidationRdfModelEmitter$.MODULE$.$lessinit$greater$default$3()).emit(shapes);
        return var3_3;
    }

    @Override
    public RdfModel emptyRdfModel() {
        return new JenaRdfModel(JenaRdfModel$.MODULE$.$lessinit$greater$default$1());
    }

    public SHACLValidator() {
        RdfFramework.$init$(this);
        this.functionUrl = None$.MODULE$;
        this.functionCode = None$.MODULE$;
        this.formats = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/ld+json"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"application/json"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JSON-LD"), (Object)"JSON-LD"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"text/n3"), (Object)"N3"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test/turtle"), (Object)"TURTLE")}));
    }
}

