/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.nodes.snakeyaml;

import java.io.Reader;
import java.io.StringReader;
import javax.annotation.Nullable;
import org.apache.commons.lang.SystemUtils;
import org.raml.v2.api.loader.DefaultResourceLoader;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.nodes.DefaultPosition;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.Position;
import org.raml.yagi.framework.nodes.snakeyaml.LimitsException;
import org.raml.yagi.framework.nodes.snakeyaml.SYModelWrapper;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public class NodeParser {
    @Nullable
    public static Node parse(ResourceLoader resourceLoader, String resourcePath, Reader reader) {
        try {
            Yaml yamlParser = new Yaml();
            org.yaml.snakeyaml.nodes.Node composedNode = yamlParser.compose(reader);
            if (composedNode == null) {
                return null;
            }
            try {
                return new SYModelWrapper(resourceLoader, resourcePath).wrap(composedNode, 0);
            }
            catch (LimitsException e) {
                return ErrorNodeFactory.limitsExceptionThrown(e);
            }
        }
        catch (MarkedYAMLException e) {
            return NodeParser.buildYamlErrorNode(e);
        }
    }

    private static Node buildYamlErrorNode(MarkedYAMLException e) {
        ErrorNode errorNode = new ErrorNode("Underlying error while parsing YAML syntax: '" + e.getMessage() + "'");
        Mark problemMark = e.getProblemMark();
        errorNode.setStartPosition((Position)new DefaultPosition(problemMark.getIndex(), problemMark.getLine(), 0, "", (ResourceLoader)new DefaultResourceLoader()));
        errorNode.setEndPosition((Position)new DefaultPosition(problemMark.getIndex() + 1, problemMark.getLine(), problemMark.getColumn(), "", (ResourceLoader)new DefaultResourceLoader()));
        return errorNode;
    }

    @Nullable
    public static Node parse(ResourceLoader resourceLoader, String resourcePath, String content) {
        if (SystemUtils.IS_OS_WINDOWS) {
            content = content.replace("\r\n", "\n");
        }
        return NodeParser.parse(resourceLoader, resourcePath, new StringReader(content));
    }
}

