/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.config.builders;

import java.util.ArrayList;
import java.util.List;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.lifecycle.LifecycleManager;

public abstract class AbstractConfigurationBuilder
implements ConfigurationBuilder {
    protected final List<ServiceConfigurator> serviceConfigurators = new ArrayList<ServiceConfigurator>();

    @Override
    public void addServiceConfigurator(ServiceConfigurator serviceConfigurator) {
        Preconditions.checkArgument((serviceConfigurator != null ? 1 : 0) != 0, (String)"serviceConfigurator cannot be null");
        this.serviceConfigurators.add(serviceConfigurator);
    }

    @Override
    public void configure(MuleContext muleContext) throws ConfigurationException {
        try {
            this.doConfigure(muleContext);
            this.applyLifecycle(muleContext.getLifecycleManager());
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    protected abstract void doConfigure(MuleContext var1) throws Exception;

    protected void applyLifecycle(LifecycleManager lifecycleManager) throws Exception {
    }
}

