/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEventContextService
implements EventContextService {
    private static Logger LOGGER = LoggerFactory.getLogger(DefaultEventContextService.class);
    private final ReferenceQueue<DefaultEventContext> queue = new ReferenceQueue();
    private Set<WeakReference<DefaultEventContext>> currentContexts = ConcurrentHashMap.newKeySet(512);

    @Override
    public List<EventContextService.FlowStackEntry> getCurrentlyActiveFlowStacks() {
        ArrayList<EventContextService.FlowStackEntry> flowStacks = new ArrayList<EventContextService.FlowStackEntry>();
        HashSet<WeakReference<DefaultEventContext>> gcdContexts = new HashSet<WeakReference<DefaultEventContext>>();
        for (WeakReference<DefaultEventContext> contextRef : this.currentContexts) {
            DefaultEventContext context = (DefaultEventContext)contextRef.get();
            if (context == null) {
                gcdContexts.add(contextRef);
                continue;
            }
            flowStacks.add(new DefaultFlowStackEntry(context));
            context.forEachChild(childContext -> flowStacks.add(new DefaultFlowStackEntry((BaseEventContext)childContext)));
        }
        this.currentContexts.removeAll(gcdContexts);
        return flowStacks;
    }

    public void addContext(DefaultEventContext context) {
        this.currentContexts.add(new WeakReference<DefaultEventContext>(context, this.queue));
    }

    public void removeContext(DefaultEventContext context) {
        Reference<DefaultEventContext> polled = this.queue.poll();
        while (polled != null) {
            LOGGER.warn("EventContext with id {} was not terminated.", (Object)polled.get().getId());
            this.currentContexts.remove(polled);
            polled = this.queue.poll();
        }
    }

    private static final class DefaultFlowStackEntry
    implements EventContextService.FlowStackEntry {
        private final String serverId;
        private final String eventId;
        private final FlowCallStack flowCallStack;

        public DefaultFlowStackEntry(BaseEventContext context) {
            this.serverId = context.getServerId();
            this.eventId = context.getId();
            this.flowCallStack = context.getFlowCallStack().clone();
        }

        @Override
        public String getServerId() {
            return this.serverId;
        }

        @Override
        public String getEventId() {
            return this.eventId;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.flowCallStack;
        }

        public String toString() {
            return "eventId: " + this.eventId + ";" + System.lineSeparator() + this.getFlowCallStack().toString();
        }
    }
}

