/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.core.api.exception.Errors;
import org.mule.runtime.core.internal.message.ErrorTypeBuilder;

public class DefaultErrorTypeRepository
implements ErrorTypeRepository {
    private static final ErrorType ANY_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("ANY").build();
    private static final ErrorType SOURCE_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("SOURCE").parentErrorType(ANY_ERROR_TYPE).build();
    private static final ErrorType SOURCE_RESPONSE_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("SOURCE_RESPONSE").parentErrorType(SOURCE_ERROR_TYPE).build();
    private static final ErrorType UNKNOWN_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("UNKNOWN").parentErrorType(ANY_ERROR_TYPE).build();
    public static final ErrorType CRITICAL_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("CRITICAL").parentErrorType(null).build();
    private Map<ComponentIdentifier, ErrorType> errorTypes = new HashMap<ComponentIdentifier, ErrorType>();
    private Map<ComponentIdentifier, ErrorType> internalErrorTypes = new HashMap<ComponentIdentifier, ErrorType>();

    public DefaultErrorTypeRepository() {
        this.errorTypes.put(Errors.ComponentIdentifiers.Handleable.ANY, ANY_ERROR_TYPE);
        this.errorTypes.put(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE, SOURCE_RESPONSE_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.Handleable.SOURCE, SOURCE_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.Unhandleable.CRITICAL, CRITICAL_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.Handleable.UNKNOWN, UNKNOWN_ERROR_TYPE);
    }

    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        ErrorType errorType = this.buildErrorType(errorTypeIdentifier, parentErrorType);
        this.errorTypes.put(errorTypeIdentifier, errorType);
        return errorType;
    }

    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        ErrorType errorType = this.buildErrorType(errorTypeIdentifier, parentErrorType);
        this.internalErrorTypes.put(errorTypeIdentifier, errorType);
        return errorType;
    }

    private ErrorType buildErrorType(ComponentIdentifier identifier, ErrorType parent) {
        if (this.errorTypes.containsKey(identifier) || this.internalErrorTypes.containsKey(identifier)) {
            throw new IllegalStateException(String.format("An error type with identifier '%s' already exists", identifier));
        }
        return ErrorTypeBuilder.builder().namespace(identifier.getNamespace()).identifier(identifier.getName()).parentErrorType(parent).build();
    }

    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        return Optional.ofNullable(this.errorTypes.get(errorTypeComponentIdentifier));
    }

    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        Optional<ErrorType> errorType = this.lookupErrorType(errorTypeIdentifier);
        if (!errorType.isPresent()) {
            errorType = Optional.ofNullable(this.internalErrorTypes.get(errorTypeIdentifier));
        }
        return errorType;
    }

    public Collection<String> getErrorNamespaces() {
        return Stream.concat(this.errorTypes.keySet().stream(), this.internalErrorTypes.keySet().stream()).map(id -> id.getNamespace().toUpperCase()).collect(Collectors.toSet());
    }

    public ErrorType getAnyErrorType() {
        return ANY_ERROR_TYPE;
    }

    public ErrorType getSourceErrorType() {
        return SOURCE_ERROR_TYPE;
    }

    public ErrorType getSourceResponseErrorType() {
        return SOURCE_RESPONSE_ERROR_TYPE;
    }

    public ErrorType getCriticalErrorType() {
        return CRITICAL_ERROR_TYPE;
    }
}

