/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.transformation.TransformationService;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.StringMessageUtils;
import org.mule.runtime.core.internal.routing.RoutingFailedException;
import org.mule.runtime.core.internal.routing.RoutingStrategy;
import org.mule.runtime.core.privileged.connector.DispatchException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.routing.RoutingException;
import org.mule.runtime.core.privileged.transformer.ExtendedTransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirstSuccessfulRoutingStrategy
implements RoutingStrategy {
    @Inject
    private TransformationService transformationService;
    protected static transient Logger logger = LoggerFactory.getLogger(FirstSuccessfulRoutingStrategy.class);
    private final RouteProcessor processor;

    public FirstSuccessfulRoutingStrategy(RouteProcessor processor) {
        this.processor = processor;
    }

    public static void validateMessageIsNotConsumable(Message message) {
        if (message.getPayload().getDataType().isStreamType()) {
            throw new MuleRuntimeException(CoreMessages.cannotCopyStreamPayload(message.getPayload().getDataType().getType().getName()));
        }
    }

    @Override
    public CoreEvent route(CoreEvent event, List<Processor> messageProcessors) throws MuleException {
        CoreEvent returnEvent = null;
        boolean failed = true;
        Exception failExceptionCause = null;
        FirstSuccessfulRoutingStrategy.validateMessageIsNotConsumable(event.getMessage());
        for (Processor mp : messageProcessors) {
            try {
                returnEvent = MessageProcessors.processToApplyWithChildContext(event, mp);
                failed = returnEvent == null ? false : (returnEvent.getMessage() == null ? true : returnEvent.getError().isPresent());
            }
            catch (Exception ex) {
                failed = true;
                failExceptionCause = ex;
            }
            if (failed) continue;
            break;
        }
        if (failed) {
            if (failExceptionCause != null) {
                throw new RoutingFailedException(I18nMessageFactory.createStaticMessage((String)"All processors failed during 'first-successful' routing strategy"), failExceptionCause);
            }
            throw new RoutingFailedException(I18nMessageFactory.createStaticMessage((String)"All processors failed during 'first-successful' routing strategy"));
        }
        return returnEvent != null ? CoreEvent.builder(event.getContext(), returnEvent).build() : null;
    }

    protected final CoreEvent sendRequest(CoreEvent routedEvent, Message message, Processor route, boolean awaitResponse) throws MuleException {
        CoreEvent result;
        try {
            result = this.sendRequestEvent(routedEvent, message, route, awaitResponse);
        }
        catch (MuleException me) {
            throw me;
        }
        catch (Exception e) {
            throw new RoutingException(null, e);
        }
        if (result != null) {
            Message resultMessage = result.getMessage();
            if (logger.isTraceEnabled() && resultMessage != null) {
                try {
                    logger.trace("Response payload: \n" + StringMessageUtils.truncate(((ExtendedTransformationService)this.transformationService).getPayloadForLogging(resultMessage), 100, false));
                }
                catch (Exception e) {
                    logger.trace("Response payload: \n(unable to retrieve payload: " + e.getMessage());
                }
            }
        }
        return result;
    }

    private CoreEvent sendRequestEvent(CoreEvent routedEvent, Message message, Processor route, boolean awaitResponse) throws MuleException {
        if (route == null) {
            throw new DispatchException(CoreMessages.objectIsNull("route"), null);
        }
        return route.process(routedEvent);
    }

    static interface RouteProcessor {
        public CoreEvent processRoute(Processor var1, CoreEvent var2) throws MuleException;
    }
}

