/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.exception.MessagingException;
import org.mule.runtime.core.internal.routing.ExpressionSplittingStrategy;
import org.mule.runtime.core.internal.routing.SplittingStrategy;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurer;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurerIterator;
import org.mule.runtime.core.internal.routing.outbound.EventBuilderConfigurerList;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.Scope;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Foreach
extends AbstractMessageProcessorOwner
implements Initialisable,
Scope {
    public static final String DEFAULT_ROOT_MESSAGE_VARIABLE = "rootMessage";
    static final String DEFAULT_COUNTER_VARIABLE = "counter";
    static final String MAP_NOT_SUPPORTED_MESSAGE = "Foreach does not support 'java.util.Map' with no collection expression. To iterate over Map entries use '#[dw::core::Objects::entrySet(payload)]'";
    private List<Processor> messageProcessors;
    private String expression = "#[payload]";
    private int batchSize = 1;
    private SplittingStrategy<CoreEvent, Iterator<TypedValue<?>>> splittingStrategy;
    private String rootMessageVariableName = "rootMessage";
    private String counterVariableName = "counter";
    private MessageProcessorChain nestedChain;

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        return MessageProcessors.processToApply(event, this);
    }

    @Override
    public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
        return Flux.from(publisher).doOnNext(event -> {
            if (this.expression.equals("#[payload]") && Map.class.isAssignableFrom(event.getMessage().getPayload().getDataType().getType())) {
                throw new IllegalArgumentException(MAP_NOT_SUPPORTED_MESSAGE);
            }
        }).flatMap(originalEvent -> {
            Object previousCounterVar = originalEvent.getVariables().containsKey(this.counterVariableName) ? ((TypedValue)originalEvent.getVariables().get(this.counterVariableName)).getValue() : null;
            Object previousRootMessageVar = originalEvent.getVariables().containsKey(this.rootMessageVariableName) ? ((TypedValue)originalEvent.getVariables().get(this.rootMessageVariableName)).getValue() : null;
            CoreEvent requestEvent = CoreEvent.builder(originalEvent).addVariable(this.rootMessageVariableName, originalEvent.getMessage()).build();
            return this.splitAndProcess(requestEvent).map(result -> {
                CoreEvent.Builder responseBuilder = CoreEvent.builder(result).message(originalEvent.getMessage());
                this.restoreVariables(previousCounterVar, previousRootMessageVar, responseBuilder);
                return responseBuilder.build();
            }).onErrorMap(MessagingException.class, me -> {
                CoreEvent.Builder exceptionEventBuilder = CoreEvent.builder(me.getEvent());
                this.restoreVariables(previousCounterVar, previousRootMessageVar, exceptionEventBuilder);
                me.setProcessedEvent(exceptionEventBuilder.build());
                return me;
            });
        });
    }

    private void restoreVariables(Object previousCounterVar, Object previousRootMessageVar, CoreEvent.Builder responseBuilder) {
        if (previousCounterVar != null) {
            responseBuilder.addVariable(this.counterVariableName, previousCounterVar);
        } else {
            responseBuilder.removeVariable(this.counterVariableName);
        }
        if (previousRootMessageVar != null) {
            responseBuilder.addVariable(this.rootMessageVariableName, previousRootMessageVar);
        } else {
            responseBuilder.removeVariable(this.rootMessageVariableName);
        }
    }

    private Flux<CoreEvent> splitAndProcess(CoreEvent request) {
        AtomicInteger count = new AtomicInteger();
        AtomicReference<CoreEvent> currentEvent = new AtomicReference<CoreEvent>(request);
        return Flux.fromIterable(() -> this.splitRequest(request)).onErrorMap(throwable -> new MessagingException(request, (Throwable)throwable, (Component)this)).transform(p -> this.batchSize > 1 ? Flux.from((Publisher)p).buffer(this.batchSize).map(list -> new TypedValue(list, DataType.fromObject((Object)list))) : p).concatMap(typedValue -> {
            CoreEvent.Builder partEventBuilder = CoreEvent.builder((CoreEvent)currentEvent.get());
            if (typedValue.getValue() instanceof EventBuilderConfigurer) {
                ((EventBuilderConfigurer)typedValue.getValue()).configure(partEventBuilder);
            } else if (typedValue.getValue() instanceof Message) {
                partEventBuilder.message((Message)typedValue.getValue());
            } else {
                partEventBuilder.message(Message.builder().payload(typedValue).build());
            }
            return Flux.from(MessageProcessors.processWithChildContext(partEventBuilder.addVariable(this.counterVariableName, count.incrementAndGet()).build(), (ReactiveProcessor)this.nestedChain, Optional.ofNullable(this.getLocation()))).doOnNext(result -> currentEvent.set(CoreEvent.builder(result).build()));
        }).switchIfEmpty((Publisher)Mono.defer(() -> {
            if (count.get() == 0) {
                this.logger.warn("Split expression returned no results. If this is not expected please check your expression");
                return Mono.just((Object)request);
            }
            return Mono.empty();
        })).takeLast(1).map(s -> CoreEvent.builder((CoreEvent)currentEvent.get()).message(request.getMessage()).build()).errorStrategyStop();
    }

    private Iterator<TypedValue<?>> splitRequest(CoreEvent request) {
        Object payloadValue = request.getMessage().getPayload().getValue();
        if ("#[payload]".equals(this.expression) && payloadValue instanceof EventBuilderConfigurerList) {
            return Iterators.transform(((EventBuilderConfigurerList)payloadValue).eventBuilderConfigurerIterator(), input -> TypedValue.of((Object)input));
        }
        if ("#[payload]".equals(this.expression) && payloadValue instanceof EventBuilderConfigurerIterator) {
            return new EventBuilderConfigurerIteratorWrapper((EventBuilderConfigurerIterator)payloadValue);
        }
        return this.splittingStrategy.split(request);
    }

    @Override
    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.nestedChain);
    }

    public void setMessageProcessors(List<Processor> messageProcessors) throws MuleException {
        this.messageProcessors = messageProcessors;
    }

    @Override
    public void initialise() throws InitialisationException {
        Optional<ProcessingStrategy> processingStrategy = MessageProcessors.getProcessingStrategy(this.locator, this.getRootContainerLocation());
        this.nestedChain = MessageProcessors.newChain(processingStrategy, this.messageProcessors);
        this.splittingStrategy = new ExpressionSplittingStrategy(this.muleContext.getExpressionManager(), this.expression);
        super.initialise();
    }

    public void setCollectionExpression(String expression) {
        this.expression = expression;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setRootMessageVariableName(String rootMessageVariableName) {
        this.rootMessageVariableName = rootMessageVariableName;
    }

    public void setCounterVariableName(String counterVariableName) {
        this.counterVariableName = counterVariableName;
    }

    private static class EventBuilderConfigurerIteratorWrapper
    implements Iterator<TypedValue<?>> {
        private final EventBuilderConfigurerIterator configurerIterator;

        public EventBuilderConfigurerIteratorWrapper(EventBuilderConfigurerIterator configurerIterator) {
            this.configurerIterator = configurerIterator;
        }

        @Override
        public boolean hasNext() {
            return this.configurerIterator.hasNext();
        }

        @Override
        public TypedValue<?> next() {
            return TypedValue.of((Object)this.configurerIterator.nextEventBuilderConfigurer());
        }
    }
}

