/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.mule.runtime.api.scheduler.Scheduler;

public class ConditionalExecutorServiceDecorator
implements ExecutorService {
    private Scheduler delegate;
    private Predicate<Scheduler> scheduleOverridePredicate;
    private ExecutorService directExecutor = MoreExecutors.newDirectExecutorService();

    public ConditionalExecutorServiceDecorator(Scheduler executorService, Predicate<Scheduler> scheduleOverridePredicate) {
        this.delegate = executorService;
        this.scheduleOverridePredicate = scheduleOverridePredicate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
        this.directExecutor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.directExecutor.shutdownNow();
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.directExecutor.isShutdown() && this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.directExecutor.isTerminated() && this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.directExecutor.awaitTermination(0L, unit) && this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.submit(task);
        }
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.submit(task, result);
        }
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.submit(task);
        }
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.invokeAll(tasks);
        }
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.invokeAll(tasks, timeout, unit);
        }
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.invokeAny(tasks);
        }
        return (T)this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.invokeAny(tasks, timeout, unit);
        }
        return (T)this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            this.directExecutor.execute(command);
        } else {
            this.delegate.execute(command);
        }
    }
}

