/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.providers.grizzly.TransportCustomizer;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.http.HttpCodecFilter;
import org.glassfish.grizzly.http.HttpProbe;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.service.http.impl.service.HttpMessageLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggerTransportCustomizer
implements TransportCustomizer {
    private static final Logger logger = LoggerFactory.getLogger(LoggerTransportCustomizer.class);

    public void customize(TCPNIOTransport transport, FilterChainBuilder filterChainBuilder) {
        HttpCodecFilter httpCodecFilter = this.findHttpCodecFilter(filterChainBuilder);
        httpCodecFilter.getMonitoringConfig().addProbes((Object[])new HttpProbe[]{new HttpMessageLogger(HttpMessageLogger.LoggerType.REQUESTER, Thread.currentThread().getContextClassLoader())});
    }

    private HttpCodecFilter findHttpCodecFilter(FilterChainBuilder filterChainBuilder) {
        HttpCodecFilter httpCodecFilter = null;
        try {
            int i = 0;
            do {
                Filter filter;
                if ((filter = filterChainBuilder.get(i)) instanceof HttpCodecFilter) {
                    httpCodecFilter = (HttpCodecFilter)filter;
                }
                ++i;
            } while (httpCodecFilter == null);
        }
        catch (IndexOutOfBoundsException e) {
            logger.error(String.format("Failure looking for %s in grizzly client transport", HttpCodecFilter.class.getName()));
            throw new MuleRuntimeException((Throwable)e);
        }
        return httpCodecFilter;
    }
}

