/*
 * Decompiled with CFR 0.152.
 */
package reactor.retry;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import reactor.retry.BackoffDelay;

public interface Jitter
extends Function<BackoffDelay, Duration> {
    public static final Jitter NO_JITTER = new Jitter(){

        @Override
        public Duration apply(BackoffDelay delay) {
            return delay.delay();
        }

        public String toString() {
            return "Jitter{NONE}";
        }
    };
    public static final Jitter RANDOM_JITTER = new Jitter(){

        @Override
        public Duration apply(BackoffDelay backoff) {
            long minBackoffMs;
            ThreadLocalRandom random = ThreadLocalRandom.current();
            long backoffMs = backoff.delay().toMillis();
            long jitterBackoffMs = backoffMs == (minBackoffMs = backoff.min.toMillis()) ? minBackoffMs : random.nextLong(minBackoffMs, backoffMs);
            return Duration.ofMillis(jitterBackoffMs);
        }

        public String toString() {
            return "Jitter{RANDOM}";
        }
    };

    public static Jitter noJitter() {
        return NO_JITTER;
    }

    public static Jitter random() {
        return RANDOM_JITTER;
    }
}

