/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.execution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.internal.execution.EndProcessPhase;
import org.mule.runtime.core.internal.execution.FlowProcessingPhase;
import org.mule.runtime.core.internal.execution.MessageProcessPhase;
import org.mule.runtime.core.internal.execution.ModuleFlowProcessingPhase;
import org.mule.runtime.core.internal.execution.PhaseExecutionEngine;
import org.mule.runtime.core.internal.execution.ValidationPhase;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.core.privileged.execution.MessageProcessContext;
import org.mule.runtime.core.privileged.execution.MessageProcessTemplate;
import org.mule.runtime.core.privileged.execution.MessageProcessingManager;

public class MuleMessageProcessingManager
implements MessageProcessingManager,
Initialisable {
    private final EndProcessPhase endProcessPhase = new EndProcessPhase();
    private MuleContext muleContext;
    private PhaseExecutionEngine phaseExecutionEngine;
    @Inject
    private PolicyManager policyManager;
    private Registry registry;
    private Collection<MessageProcessPhase> registryMessageProcessPhases;

    @Override
    public void processMessage(MessageProcessTemplate messageProcessTemplate, MessageProcessContext messageProcessContext) {
        this.phaseExecutionEngine.process(messageProcessTemplate, messageProcessContext);
    }

    @Inject
    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
    }

    @Inject
    public void setRegistryMessageProcessPhases(Optional<Collection<MessageProcessPhase>> registryMessageProcessPhases) {
        this.registryMessageProcessPhases = registryMessageProcessPhases.orElse(Collections.emptySet());
    }

    public void initialise() throws InitialisationException {
        ArrayList<MessageProcessPhase> messageProcessPhaseList = new ArrayList<MessageProcessPhase>();
        if (this.registryMessageProcessPhases != null) {
            messageProcessPhaseList.addAll(this.registryMessageProcessPhases);
        }
        messageProcessPhaseList.add(new ValidationPhase());
        messageProcessPhaseList.add(new FlowProcessingPhase(this.registry));
        messageProcessPhaseList.add(new ModuleFlowProcessingPhase(this.policyManager));
        Collections.sort(messageProcessPhaseList, (messageProcessPhase, messageProcessPhase2) -> {
            int compareValue = 0;
            if (messageProcessPhase instanceof Comparable) {
                compareValue = ((Comparable)((Object)messageProcessPhase)).compareTo(messageProcessPhase2);
            }
            if (compareValue == 0 && messageProcessPhase2 instanceof Comparable) {
                compareValue = ((Comparable)((Object)messageProcessPhase2)).compareTo(messageProcessPhase) * -1;
            }
            return compareValue;
        });
        for (MessageProcessPhase messageProcessPhase3 : messageProcessPhaseList) {
            LifecycleUtils.initialiseIfNeeded(messageProcessPhase3, this.muleContext);
        }
        this.phaseExecutionEngine = new PhaseExecutionEngine(messageProcessPhaseList, this.muleContext.getExceptionListener(), this.endProcessPhase);
    }

    @Inject
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }
}

