/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.internal.dsl.model.extension.xml.MacroExpansionModuleModel;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.config.internal.model.ComponentModel;
import org.mule.runtime.extension.api.property.XmlExtensionModelProperty;

public class MacroExpansionModulesModel {
    private final ApplicationModel applicationModel;
    private final List<ExtensionModel> sortedExtensions;

    public MacroExpansionModulesModel(ApplicationModel applicationModel, Set<ExtensionModel> extensions) {
        this.applicationModel = applicationModel;
        this.sortedExtensions = this.calculateExtensionByTopologicalOrder(extensions);
    }

    public void expand() {
        for (ExtensionModel sortedExtension : this.sortedExtensions) {
            new MacroExpansionModuleModel(this.applicationModel, sortedExtension).expand();
        }
    }

    private List<ExtensionModel> calculateExtensionByTopologicalOrder(Set<ExtensionModel> extensions) {
        ArrayList<ExtensionModel> result = new ArrayList<ExtensionModel>();
        Map allExtensionsByNamespace = extensions.stream().filter(extensionModel -> extensionModel.getModelProperty(XmlExtensionModelProperty.class).isPresent()).collect(Collectors.toMap(extModel -> extModel.getXmlDslModel().getNamespace(), Function.identity()));
        if (!allExtensionsByNamespace.isEmpty()) {
            HashSet extensionsUsedInApp = new HashSet();
            this.applicationModel.executeOnEveryMuleComponentTree(rootComponentModel -> extensionsUsedInApp.addAll(this.getDirectExpandableNamespaceDependencies((ComponentModel)rootComponentModel, allExtensionsByNamespace.keySet())));
            if (!extensionsUsedInApp.isEmpty()) {
                DirectedMultigraph namespaceDAG = new DirectedMultigraph(DefaultEdge.class);
                extensionsUsedInApp.stream().forEach(arg_0 -> this.lambda$calculateExtensionByTopologicalOrder$3((DirectedGraph)namespaceDAG, allExtensionsByNamespace, arg_0));
                TopologicalOrderIterator graphIterator = new TopologicalOrderIterator((DirectedGraph)namespaceDAG);
                while (graphIterator.hasNext()) {
                    String namespace = (String)graphIterator.next();
                    if (!allExtensionsByNamespace.containsKey(namespace)) continue;
                    result.add((ExtensionModel)allExtensionsByNamespace.get(namespace));
                }
            }
        }
        return result;
    }

    private void fillDependencyGraph(DirectedGraph<String, DefaultEdge> g, String sourceVertex, Map<String, ExtensionModel> allExtensionsByNamespace) {
        ExtensionModel extensionModel = allExtensionsByNamespace.get(sourceVertex);
        g.addVertex((Object)sourceVertex);
        for (String dependencyNamespace : this.getDependenciesOrFail(extensionModel)) {
            if (!allExtensionsByNamespace.containsKey(dependencyNamespace)) continue;
            g.addVertex((Object)dependencyNamespace);
            g.addEdge((Object)sourceVertex, (Object)dependencyNamespace);
            this.fillDependencyGraph(g, dependencyNamespace, allExtensionsByNamespace);
        }
    }

    private Set<String> getDependenciesOrFail(ExtensionModel extensionModel) {
        return ((XmlExtensionModelProperty)extensionModel.getModelProperty(XmlExtensionModelProperty.class).orElseThrow(() -> new IllegalArgumentException(String.format("The current extension [%s] (namespace [%s]) does not have the macro expansion model property, it should have never reach here.", extensionModel.getName(), extensionModel.getXmlDslModel().getNamespace())))).getNamespacesDependencies();
    }

    private Set<String> getDirectExpandableNamespaceDependencies(ComponentModel rootComponentModel, Set<String> namespacesExtensions) {
        return MacroExpansionModulesModel.getUsedNamespaces(rootComponentModel).stream().filter(namespacesExtensions::contains).collect(Collectors.toSet());
    }

    public static Set<String> getUsedNamespaces(ComponentModel rootComponentModel) {
        return rootComponentModel.getParameters().entrySet().stream().filter(parameter -> ((String)parameter.getKey()).startsWith("xmlns:")).map(Map.Entry::getValue).collect(Collectors.toSet());
    }

    private /* synthetic */ void lambda$calculateExtensionByTopologicalOrder$3(DirectedGraph namespaceDAG, Map allExtensionsByNamespace, String namespace) {
        this.fillDependencyGraph((DirectedGraph<String, DefaultEdge>)namespaceDAG, namespace, allExtensionsByNamespace);
    }
}

