/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.annotation.connectivity.oauth.AuthorizationCode;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class OAuthConnectionProviderModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel model, ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            protected void onConnectionProvider(ConnectionProviderModel model) {
                model.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).filter(type -> type.getAnnotation(AuthorizationCode.class) != null).ifPresent(type -> {
                    List stateFields = IntrospectionUtils.getFields(type).stream().filter(f -> f.getType().equals(AuthorizationCodeState.class)).collect(Collectors.toList());
                    if (stateFields.size() != 1) {
                        throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection Provider of class '%s' uses OAuth2 authorization code grant type and thus should contain one (and only one) field of type %s. %d were found", type, AuthorizationCodeState.class.getName(), stateFields.size()));
                    }
                });
            }
        }.walk(model);
    }
}

