/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.connection.util.ConnectionProviderUtils;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.util.ExceptionUtils;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.extension.api.connectivity.oauth.AccessTokenExpiredException;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ExtensionsOAuthManager;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.OAuthConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class OAuthOperationMessageProcessor
extends OperationMessageProcessor {
    private static Logger LOGGER = LoggerFactory.getLogger(OAuthOperationMessageProcessor.class);
    private final ExtensionsOAuthManager oauthManager;

    public OAuthOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, String targetValue, ResolverSet resolverSet, CursorProviderFactory cursorProviderFactory, RetryPolicyTemplate retryPolicyTemplate, ExtensionManager extensionManager, PolicyManager policyManager, ReflectionCache reflectionCache, ExtensionsOAuthManager oauthManager) {
        super(extensionModel, operationModel, configurationProvider, target, targetValue, resolverSet, cursorProviderFactory, retryPolicyTemplate, extensionManager, policyManager, reflectionCache);
        this.oauthManager = oauthManager;
    }

    @Override
    protected Mono<CoreEvent> doProcess(CoreEvent event, ExecutionContextAdapter<OperationModel> operationContext) {
        return super.doProcess(event, operationContext).onErrorResume(AccessTokenExpiredException.class, e -> {
            OAuthConnectionProviderWrapper connectionProvider = this.getOAuthConnectionProvider(operationContext);
            if (connectionProvider == null) {
                return Mono.error((Throwable)e);
            }
            AccessTokenExpiredException expiredException = this.getTokenExpirationException((Exception)e);
            if (expiredException != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("AccessToken for resourceOwner '%s' expired while executing operation '%s:%s' using config '%s'. Will attempt to refresh token and retry operation", connectionProvider.getResourceOwnerId(), this.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName()));
                }
                String ownerConfigName = ((ConfigurationInstance)operationContext.getConfiguration().get()).getName();
                try {
                    this.oauthManager.refreshToken(ownerConfigName, expiredException.getResourceOwnerId(), this.getOAuthConnectionProvider(operationContext));
                }
                catch (Exception refreshException) {
                    return Mono.error((Throwable)new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("AccessToken for resourceOwner '%s' expired while executing operation '%s:%s' using config '%s'. Refresh token workflow was attempted but failed with the following exception", connectionProvider.getResourceOwnerId(), this.getExtensionModel().getName(), ((OperationModel)operationContext.getComponentModel()).getName(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName())), (Throwable)refreshException));
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("Access Token successfully refreshed for resourceOwnerId '%s' on config '%s'", connectionProvider.getResourceOwnerId(), ((ConfigurationInstance)operationContext.getConfiguration().get()).getName()));
                }
                return super.doProcess(event, operationContext);
            }
            return Mono.error((Throwable)e);
        });
    }

    private AccessTokenExpiredException getTokenExpirationException(Exception e) {
        return e instanceof AccessTokenExpiredException ? (AccessTokenExpiredException)e : (AccessTokenExpiredException)ExceptionUtils.extractCauseOfType((Throwable)e, AccessTokenExpiredException.class).orElse(null);
    }

    private OAuthConnectionProviderWrapper getOAuthConnectionProvider(ExecutionContextAdapter operationContext) {
        ConfigurationInstance config = (ConfigurationInstance)operationContext.getConfiguration().get();
        ConnectionProvider provider = ConnectionProviderUtils.unwrapProviderWrapper((ConnectionProvider)((ConnectionProvider)config.getConnectionProvider().get()), OAuthConnectionProviderWrapper.class);
        return provider instanceof OAuthConnectionProviderWrapper ? (OAuthConnectionProviderWrapper)provider : null;
    }
}

