/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.message;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.util.message.ResultToMessageListIterator;
import org.mule.runtime.core.internal.util.message.ResultsToMessageCollection;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class ResultsToMessageList
extends ResultsToMessageCollection
implements List<Message> {
    private final List<Object> delegate;

    public ResultsToMessageList(List<Object> delegate, CursorProviderFactory cursorProviderFactory, CoreEvent event) {
        super(delegate, cursorProviderFactory, event);
        this.delegate = delegate;
    }

    @Override
    public void add(int index, Message element) {
        this.lock.withWriteLock(() -> this.delegate.add(index, element));
    }

    @Override
    public boolean addAll(int index, Collection<? extends Message> c) {
        return this.lock.withWriteLock(() -> this.delegate.addAll(index, c));
    }

    @Override
    public int indexOf(Object o) {
        return this.lock.withReadLock(r -> {
            int i = this.delegate.indexOf(o);
            if (i == -1 && o instanceof Message) {
                i = this.delegate.indexOf(Result.builder((Message)((Message)o)).build());
            }
            return i;
        });
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.lock.withReadLock(r -> {
            int i = this.delegate.lastIndexOf(o);
            if (i == -1 && o instanceof Message) {
                i = this.delegate.lastIndexOf(Result.builder((Message)((Message)o)).build());
            }
            return i;
        });
    }

    @Override
    public void sort(Comparator<? super Message> c) {
        this.lock.withWriteLock(() -> this.delegate.sort((o1, o2) -> c.compare(this.toMessage(o1, this.cursorProviderFactory, this.event), this.toMessage(o2, this.cursorProviderFactory, this.event))));
    }

    @Override
    public Message get(int index) {
        return (Message)this.lock.withReadLock(r -> {
            Object value = this.delegate.get(index);
            if (value instanceof Message) {
                return value;
            }
            r.release();
            return this.lock.withWriteLock(() -> {
                Object update = this.delegate.get(index);
                if (update instanceof Message) {
                    return update;
                }
                update = this.toMessage(update, this.cursorProviderFactory, this.event);
                this.delegate.set(index, update);
                return update;
            });
        });
    }

    @Override
    public Message set(int index, Message message) {
        return this.lock.withWriteLock(() -> {
            Object previous = this.delegate.set(index, message);
            return previous != null ? this.toMessage(previous, this.cursorProviderFactory, this.event) : null;
        });
    }

    @Override
    public Message remove(int index) {
        return this.lock.withWriteLock(() -> {
            Object previous = this.delegate.remove(index);
            return previous != null ? this.toMessage(previous, this.cursorProviderFactory, this.event) : null;
        });
    }

    @Override
    public Iterator<Message> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<Message> listIterator() {
        return new ResultToMessageListIterator(this);
    }

    @Override
    public ListIterator<Message> listIterator(int index) {
        return new ResultToMessageListIterator(this);
    }

    @Override
    public List<Message> subList(int fromIndex, int toIndex) {
        return this.lock.withReadLock(r -> {
            List<Object> results = this.delegate.subList(fromIndex, toIndex);
            return new ResultsToMessageList(results, this.cursorProviderFactory, this.event);
        });
    }
}

