/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.api.util.Preconditions;

class ImmutableMavenConfiguration
implements MavenConfiguration {
    private final List<RemoteRepository> remoteRepositories;
    private final File localMavenRepositoryLocation;
    private final Optional<File> userSettingsFileOptional;
    private final Optional<File> globalSettingsFileOptional;
    private boolean forcePolicyUpdateNever;
    private boolean offlineMode;
    private boolean ignoreArtifactDescriptorRepositories;

    public ImmutableMavenConfiguration(File localMavenRepositoryLocation, List<RemoteRepository> remoteRepositories, Optional<File> userSettingsFileOptional, Optional<File> globalSettingsFileOptional, boolean forcePolicyUpdateNever, boolean offlineMode, boolean ignoreArtifactDescriptorRepositories) {
        Set uniqueIdList = remoteRepositories.stream().map(RemoteRepository::getId).collect(Collectors.toSet());
        Preconditions.checkState(uniqueIdList.size() == remoteRepositories.size(), "The configured set of remote repositories do not have unique IDs");
        this.localMavenRepositoryLocation = localMavenRepositoryLocation;
        this.remoteRepositories = remoteRepositories;
        this.userSettingsFileOptional = userSettingsFileOptional;
        this.globalSettingsFileOptional = globalSettingsFileOptional;
        this.forcePolicyUpdateNever = forcePolicyUpdateNever;
        this.offlineMode = offlineMode;
        this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
    }

    @Override
    public File getLocalMavenRepositoryLocation() {
        return this.localMavenRepositoryLocation;
    }

    @Override
    public List<RemoteRepository> getMavenRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public Optional<File> getUserSettingsLocation() {
        return this.userSettingsFileOptional;
    }

    @Override
    public Optional<File> getGlobalSettingsLocation() {
        return this.globalSettingsFileOptional;
    }

    @Override
    public boolean getForcePolicyUpdateNever() {
        return this.forcePolicyUpdateNever;
    }

    @Override
    public boolean getOfflineMode() {
        return this.offlineMode;
    }

    @Override
    public boolean getIgnoreArtifactDescriptorRepositories() {
        return this.ignoreArtifactDescriptorRepositories;
    }

    public String toString() {
        return "ImmutableMavenConfiguration{remoteRepositories=" + this.repositoriesToString() + ", localMavenRepositoryLocation=" + this.localMavenRepositoryLocation + ", userSettingsFileOptional=" + this.userSettingsFileOptional + ", globalSettingsFileOptional=" + this.globalSettingsFileOptional + ", forcePolicyUpdateNever=" + this.forcePolicyUpdateNever + ", offlineMode=" + this.offlineMode + ", ignoreArtifactDescriptorRepositories=" + this.ignoreArtifactDescriptorRepositories + '}';
    }

    private String repositoriesToString() {
        return String.join((CharSequence)",\n", this.remoteRepositories.stream().map(Object::toString).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMavenConfiguration that = (ImmutableMavenConfiguration)o;
        if (this.forcePolicyUpdateNever != that.forcePolicyUpdateNever) {
            return false;
        }
        if (this.offlineMode != that.offlineMode) {
            return false;
        }
        if (this.ignoreArtifactDescriptorRepositories != that.ignoreArtifactDescriptorRepositories) {
            return false;
        }
        if (!this.remoteRepositories.equals(that.remoteRepositories)) {
            return false;
        }
        if (!this.localMavenRepositoryLocation.equals(that.localMavenRepositoryLocation)) {
            return false;
        }
        if (!this.userSettingsFileOptional.equals(that.userSettingsFileOptional)) {
            return false;
        }
        return this.globalSettingsFileOptional.equals(that.globalSettingsFileOptional);
    }

    public int hashCode() {
        int result = this.remoteRepositories.hashCode();
        result = 31 * result + this.localMavenRepositoryLocation.hashCode();
        result = 31 * result + this.userSettingsFileOptional.hashCode();
        result = 31 * result + this.globalSettingsFileOptional.hashCode();
        result = 31 * result + (this.forcePolicyUpdateNever ? 1 : 0);
        result = 31 * result + (this.offlineMode ? 1 : 0);
        result = 31 * result + (this.ignoreArtifactDescriptorRepositories ? 1 : 0);
        return result;
    }
}

