/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import org.junit.jupiter.api.AfterEach;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.HttpServerConfiguration;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.tck.junit5.DynamicPort;

public abstract class AbstractHttpServerTestCase
extends AbstractHttpServiceTestCase {
    @DynamicPort(systemProperty="port")
    protected Integer port;
    protected HttpServer server;

    public AbstractHttpServerTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    protected void setUpServer() throws Exception {
        this.server = this.service.getServerFactory().create(this.configureServer(new HttpServerConfiguration.Builder().setHost("localhost").setPort(this.port.intValue()).setName(this.getServerName())).build());
        this.server.start();
    }

    protected abstract String getServerName();

    protected HttpServerConfiguration.Builder configureServer(HttpServerConfiguration.Builder builder) {
        return builder;
    }

    @AfterEach
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
            this.server.dispose();
        }
    }
}

