/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantType;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthGrantTypeVisitor;
import org.mule.runtime.extension.api.connectivity.oauth.OAuthModelProperty;
import org.mule.runtime.extension.api.connectivity.oauth.PlatformManagedOAuthGrantType;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.module.extension.api.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.api.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.config.BaseConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ConnectionProviderSettings;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ImplicitConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class ConfigurationCreationUtils {
    public static ConfigurationProvider createConfigurationProvider(ExtensionModel extensionModel, ConfigurationModel configurationModel, String configName, Map<String, Object> parameters, Optional<ExpirationPolicy> expirationPolicy, Optional<ConnectionProviderValueResolver> connectionProviderResolver, ConfigurationProviderFactory configurationProviderFactory, ExpressionManager expressionManager, ReflectionCache reflectionCache, String parametersOwner, DslSyntaxResolver dslSyntaxResolver, ClassLoader extensionClassLoader, MuleContext muleContext, ArtifactEncoding artifactEncoding) {
        return (ConfigurationProvider)ClassUtils.withContextClassLoader((ClassLoader)extensionClassLoader, () -> {
            ConfigurationProvider configurationProvider;
            ResolverSet resolverSet = ResolverSetUtils.getResolverSetFromStaticValues((ParameterizedModel)configurationModel, parameters, muleContext, false, reflectionCache, expressionManager, parametersOwner, artifactEncoding);
            ConnectionProviderValueResolver connectionResolver = connectionProviderResolver.orElseGet(() -> ExtensionModelUtils.supportsConnectivity((ExtensionModel)extensionModel, (ConfigurationModel)configurationModel) ? new ImplicitConnectionProviderValueResolver(configName, extensionModel, configurationModel, reflectionCache, expressionManager, muleContext) : new StaticConnectionProviderResolver(null, null));
            connectionResolver.getResolverSet().ifPresent((Consumer<ResolverSet>)((CheckedConsumer)resolver -> LifecycleUtils.initialiseIfNeeded((Object)resolver, (boolean)true, (MuleContext)muleContext)));
            try {
                configurationProvider = resolverSet.isDynamic() || connectionResolver.isDynamic() ? configurationProviderFactory.createDynamicConfigurationProvider(configName, extensionModel, configurationModel, resolverSet, connectionResolver, ConfigurationCreationUtils.getActingExpirationPolicy(expirationPolicy, muleContext)) : configurationProviderFactory.createStaticConfigurationProvider(configName, extensionModel, configurationModel, resolverSet, connectionResolver);
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Could not create an implicit configuration '%s' for the extension '%s'", configurationModel.getName(), extensionModel.getName())), (Throwable)e);
            }
            return configurationProvider;
        });
    }

    public static <C> ConnectionProviderResolver<C> createConnectionProviderResolver(ExtensionModel extensionModel, ConnectionProviderSettings settings, ConfigurationProperties configurationProperties, ExpressionManager expressionManager, ReflectionCache reflectionCache, String parametersOwner, DslSyntaxResolver dslSyntaxResolver, MuleContext muleContext, ArtifactEncoding artifactEncoding) throws MuleException {
        ConnectionProviderModel providerModel = settings.getConnectionProviderModel();
        ResolverSet resolverSet = ResolverSetUtils.getResolverSetFromComponentParameterization(settings.getParameters(), muleContext, false, reflectionCache, expressionManager, parametersOwner, artifactEncoding);
        DefaultConnectionProviderObjectBuilder builder = providerModel.getModelProperty(OAuthModelProperty.class).isPresent() ? ConfigurationCreationUtils.resolveOAuthBuilder(extensionModel, providerModel, settings, resolverSet, configurationProperties, expressionManager, muleContext) : new DefaultConnectionProviderObjectBuilder(providerModel, resolverSet, settings.getPoolingProfile().orElse(null), settings.getReconnectionConfig().orElse(null), extensionModel, expressionManager, muleContext);
        return new ConnectionProviderResolver(builder, resolverSet, muleContext);
    }

    private static BaseConnectionProviderObjectBuilder resolveOAuthBuilder(final ExtensionModel extensionModel, final ConnectionProviderModel providerModel, final ConnectionProviderSettings settings, final ResolverSet resolverSet, final ConfigurationProperties configurationProperties, final ExpressionManager expressionManager, final MuleContext muleContext) {
        OAuthGrantType grantType = (OAuthGrantType)providerModel.getModelProperty(OAuthModelProperty.class).map(OAuthModelProperty::getGrantTypes).get().get(0);
        final Reference builder = new Reference();
        grantType.accept(new OAuthGrantTypeVisitor(){

            public void visit(AuthorizationCodeGrantType grantType) {
                builder.set(new AuthorizationCodeConnectionProviderObjectBuilder(providerModel, resolverSet, settings.getPoolingProfile().orElse(null), settings.getReconnectionConfig().orElse(null), grantType, settings.getAuthorizationCodeOAuthHandler(), extensionModel, expressionManager, muleContext));
            }

            public void visit(ClientCredentialsGrantType grantType) {
                builder.set(new ClientCredentialsConnectionProviderObjectBuilder(providerModel, resolverSet, settings.getPoolingProfile().orElse(null), settings.getReconnectionConfig().orElse(null), grantType, settings.getClientCredentialsOAuthHandler(), extensionModel, expressionManager, muleContext));
            }

            public void visit(PlatformManagedOAuthGrantType grantType) {
                builder.set(new PlatformManagedOAuthConnectionProviderObjectBuilder(providerModel, resolverSet, settings.getPoolingProfile().orElse(null), settings.getReconnectionConfig().orElse(null), grantType, settings.getPlatformManagedOAuthHandler(), configurationProperties, extensionModel, expressionManager, muleContext));
            }
        });
        return (BaseConnectionProviderObjectBuilder)builder.get();
    }

    private static ExpirationPolicy getActingExpirationPolicy(Optional<ExpirationPolicy> expirationPolicy, MuleContext muleContext) {
        return expirationPolicy.orElseGet(() -> muleContext.getConfiguration().getDynamicConfigExpiration().getExpirationPolicy());
    }

    private ConfigurationCreationUtils() {
    }
}

