/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.tracer.api.span.info.EnrichedInitialSpanInfo;
import org.mule.runtime.tracer.api.span.info.InitialExportInfo;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;

public class CoreEventEnrichedInitialSpanInfo
implements EnrichedInitialSpanInfo {
    private static final String CORRELATION_ID_KEY = "correlation.id";
    private static final String THREAD_START_NAME_KEY = "thread.start.name";
    private static final String THREAD_START_ID_KEY = "thread.start.id";
    public static final int ADDITIONAL_SPAN_ATTRIBUTES_COUNT = 3;
    private final InitialSpanInfo baseInitialSpanInfo;
    private final String correlationId;
    private final String threadStartName;
    private final String threadStartId;
    private final Map<String, String> tracingVariables = new HashMap<String, String>();

    public CoreEventEnrichedInitialSpanInfo(InitialSpanInfo baseInitialSpanInfo, CoreEvent coreEvent) {
        this.baseInitialSpanInfo = baseInitialSpanInfo;
        this.correlationId = coreEvent.getCorrelationId();
        this.threadStartName = Thread.currentThread().getName();
        this.threadStartId = Long.toString(Thread.currentThread().getId());
        if (coreEvent instanceof PrivilegedEvent) {
            ((PrivilegedEvent)coreEvent).getLoggingVariables().ifPresent(this.tracingVariables::putAll);
        }
    }

    public String getName() {
        return this.baseInitialSpanInfo.getName();
    }

    public InitialExportInfo getInitialExportInfo() {
        return this.baseInitialSpanInfo.getInitialExportInfo();
    }

    public void forEachAttribute(BiConsumer<String, String> biConsumer) {
        this.baseInitialSpanInfo.forEachAttribute(biConsumer);
        biConsumer.accept(CORRELATION_ID_KEY, this.correlationId);
        biConsumer.accept(THREAD_START_NAME_KEY, this.threadStartName);
        biConsumer.accept(THREAD_START_ID_KEY, this.threadStartId);
        this.tracingVariables.forEach(biConsumer);
    }

    public boolean isRootSpan() {
        return this.baseInitialSpanInfo.isRootSpan();
    }

    public boolean isPolicySpan() {
        return this.baseInitialSpanInfo.isPolicySpan();
    }

    public int getInitialAttributesCount() {
        return this.baseInitialSpanInfo.getInitialAttributesCount() + 3 + this.tracingVariables.size();
    }

    public InitialSpanInfo getBaseInitialSpanInfo() {
        return this.baseInitialSpanInfo;
    }
}

