/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.util.StringUtils;

public final class StringMessageUtils {
    public static final int MAX_ELEMENTS = 50;
    public static final int DEFAULT_MESSAGE_WIDTH = 80;

    private StringMessageUtils() {
    }

    @Deprecated(forRemoval=true, since="4.10")
    public static String getBoilerPlate(String message) {
        return StringMessageUtils.getBoilerPlate(message, '*', 80);
    }

    @Deprecated(forRemoval=true, since="4.10")
    public static String getBoilerPlate(String message, char c, int maxlength) {
        List<String> messages = Arrays.asList(message);
        messages = new ArrayList<String>(messages);
        return StringMessageUtils.getBoilerPlate(messages, c, maxlength);
    }

    @Deprecated(forRemoval=true, since="4.10")
    public static String getBoilerPlate(List<String> messages, char c, int maxlength) {
        StringBuilder buf = new StringBuilder(messages.size() * maxlength);
        int trimLength = maxlength - (c == ' ' ? 2 : 4);
        messages = messages.stream().map(string -> string.split(System.lineSeparator())).flatMap(Arrays::stream).collect(Collectors.toList());
        for (int i = 0; i < messages.size(); ++i) {
            int size = messages.get(i).toString().length();
            if (size <= trimLength) continue;
            String temp = messages.get(i).toString();
            int k = i;
            messages.remove(i);
            while (temp.length() > 0) {
                int len = trimLength <= temp.length() ? trimLength : temp.length();
                String msg = temp.substring(0, len);
                int x = msg.indexOf(System.lineSeparator());
                if (x > -1) {
                    msg = msg.substring(0, x);
                    len = x + 1;
                } else {
                    x = msg.lastIndexOf(32);
                    if (x > -1 && len == trimLength) {
                        msg = msg.substring(0, x);
                        len = x + 1;
                    }
                }
                if (msg.startsWith(" ")) {
                    msg = msg.substring(1);
                }
                temp = temp.substring(len);
                messages.add(k, msg);
                ++k;
            }
        }
        buf.append(System.lineSeparator());
        if (c != ' ') {
            buf.append(StringUtils.repeat(c, maxlength));
        }
        for (String message : messages) {
            int padding;
            buf.append(System.lineSeparator());
            if (c != ' ') {
                buf.append(c);
            }
            buf.append(" ");
            buf.append(message);
            String osEncoding = Charset.defaultCharset().name();
            try {
                padding = trimLength - message.toString().getBytes(osEncoding).length;
            }
            catch (UnsupportedEncodingException ueex) {
                throw new MuleRuntimeException(CoreMessages.failedToConvertStringUsingEncoding(osEncoding), (Throwable)ueex);
            }
            if (padding > 0) {
                buf.append(StringUtils.repeat(' ', padding));
            }
            buf.append(' ');
            if (c == ' ') continue;
            buf.append(c);
        }
        buf.append(System.lineSeparator());
        if (c != ' ') {
            buf.append(StringUtils.repeat(c, maxlength));
        }
        return buf.toString();
    }

    public static String truncate(String message, int length, boolean includeCount) {
        if (message == null) {
            return null;
        }
        if (message.length() <= length) {
            return message;
        }
        String result = message.substring(0, length) + "...";
        if (includeCount) {
            result = result + "[" + length + " of " + message.length() + "]";
        }
        return result;
    }

    public static byte[] getBytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public static String getString(byte[] bytes, String encoding) {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        if (o instanceof Map) {
            return o.toString();
        }
        if (o.getClass().isArray()) {
            return StringMessageUtils.arrayToString(o, 50);
        }
        if (o instanceof Collection) {
            return StringMessageUtils.collectionToString((Collection)o, 50, false);
        }
        return o.toString();
    }

    public static String arrayToString(Object array, int maxElements) {
        String result;
        Class<?> componentType = array.getClass().getComponentType();
        if (Object.class.isAssignableFrom(componentType)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((Object[])((Object[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Boolean.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((boolean[])((boolean[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Byte.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((byte[])((byte[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Character.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((char[])((char[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Short.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((short[])((short[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Integer.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((int[])((int[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Long.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((long[])((long[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Float.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((float[])((float[])array), (int)0, (int)maxElements));
        } else if (componentType.equals(Double.TYPE)) {
            result = ArrayUtils.toString((Object)ArrayUtils.subarray((double[])((double[])array), (int)0, (int)maxElements));
        } else {
            throw new IllegalArgumentException("Unknown array service type: " + componentType.getName());
        }
        if (Array.getLength(array) > maxElements) {
            StringBuilder buf = new StringBuilder(result);
            buf.insert(buf.length() - 1, " [..]");
            result = buf.toString();
        }
        return result;
    }

    private static String collectionToString(Collection c, int maxElements, boolean newline) {
        if (c == null || c.isEmpty()) {
            return "[]";
        }
        int origNumElements = c.size();
        int numElements = Math.min(origNumElements, maxElements);
        boolean tooManyElements = origNumElements > maxElements;
        StringBuilder buf = new StringBuilder(numElements * 32);
        buf.append('[');
        if (newline) {
            buf.append(System.lineSeparator());
        }
        Iterator items = c.iterator();
        for (int i = 0; i < numElements - 1; ++i) {
            Object item = items.next();
            if (item instanceof Class) {
                buf.append(((Class)item).getName());
            } else {
                buf.append(item);
            }
            if (newline) {
                buf.append(System.lineSeparator());
                continue;
            }
            buf.append(',').append(' ');
        }
        Object lastItem = items.next();
        if (lastItem instanceof Class) {
            buf.append(((Class)lastItem).getName());
        } else {
            buf.append(lastItem);
        }
        if (newline) {
            buf.append(System.lineSeparator());
        }
        if (tooManyElements) {
            buf.append(" [..]");
        }
        buf.append(']');
        return buf.toString();
    }
}

