/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.common.server;

import io.qameta.allure.Story;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.entity.multipart.MultipartHttpEntity;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.domain.message.response.HttpResponseBuilder;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.test.common.AbstractHttpServiceTestCase;
import org.mule.service.http.test.common.server.AbstractHttpServerTestCase;

@Story(value="Multipart")
public class HttpServerMixedPartTestCase
extends AbstractHttpServerTestCase {
    private static final String MIXED_CONTENT = "--the-boundary\r\nContent-Type: text/plain\r\nCustom: myHeader\r\nContent-Disposition: attachment; name=\"field\"\r\n\r\nMy data here\r\n--the-boundary--\r\n";

    public HttpServerMixedPartTestCase(String serviceToLoad) {
        super(serviceToLoad);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.setUpServer();
        this.server.addRequestHandler("/", (requestContext, responseCallback) -> {
            String data = "My data here";
            HttpPart part = new HttpPart("field", data.getBytes(), MediaType.TEXT.toRfcString(), data.length());
            part.addHeader("Custom", "myHeader");
            responseCallback.responseReady(((HttpResponseBuilder)((HttpResponseBuilder)HttpResponse.builder().entity((HttpEntity)new MultipartHttpEntity(Collections.singletonList(part)))).addHeader("Content-Type", MediaType.MULTIPART_MIXED.toRfcString() + "; boundary=\"the-boundary\"")).build(), (ResponseStatusCallback)new AbstractHttpServiceTestCase.IgnoreResponseStatusCallback());
        });
    }

    @Override
    protected String getServerName() {
        return "parts-test";
    }

    @Test
    void handlesMultipartMixed() throws Exception {
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            HttpGet httpPost = new HttpGet("http://localhost:" + this.port);
            try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
                MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)response.getEntity().getContent(), (Charset)StandardCharsets.UTF_8), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)MIXED_CONTENT)));
            }
        }
    }
}

