/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.service.api.artifact;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import org.mule.api.annotation.jpms.RequiredOpens;
import org.mule.api.annotation.jpms.ServiceModule;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.container.api.MuleContainerClassLoaderWrapper;
import org.mule.runtime.jpms.api.JpmsUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.ModuleLayerInformationSupplier;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.exception.ArtifactClassloaderCreationException;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.service.api.artifact.IServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.artifact.ServiceClassLoaderFactory;
import org.mule.runtime.module.service.api.artifact.ServiceDescriptor;
import org.mule.runtime.module.service.internal.artifact.ModuleLayerGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceModuleLayerFactory
extends ServiceClassLoaderFactory
implements IServiceClassLoaderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceModuleLayerFactory.class);
    private static final String CONTAINER_LAYER_NAME = "Mule Container Module Layer";
    private static final Set<String> MULE_SERVICE_MODULE_NAME_PREFIXES = new HashSet<String>(Arrays.asList("org.mule.service.", "com.mulesoft.mule.service.", "org.mule.weave.service."));
    private Optional<ModuleLayer> parentLayer = Optional.ofNullable(ServiceModuleLayerFactory.class.getModule().getLayer());

    ServiceModuleLayerFactory() {
    }

    @Override
    @Deprecated(since="4.6")
    public ArtifactClassLoader create(String artifactId, ServiceDescriptor descriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) throws ArtifactClassloaderCreationException {
        try {
            return this.doCreate(artifactId, descriptor, parent, lookupPolicy);
        }
        catch (Exception e) {
            throw new ArtifactClassloaderCreationException("Exception creating classloader for service '" + artifactId + "'", (Throwable)e);
        }
    }

    private ArtifactClassLoader doCreate(String artifactId, ServiceDescriptor descriptor, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
        URL[] classLoaderConfigurationUrls = descriptor.getClassLoaderConfiguration().getUrls();
        LOGGER.debug(" >> Creating ModuleLayer for service: '{}'...", (Object)artifactId);
        ModuleLayer artifactLayer = JpmsUtils.createModuleLayer((URL[])classLoaderConfigurationUrls, (ClassLoader)parent, this.parentLayer, (boolean)true, (boolean)true);
        Class<? extends Annotation> serviceModuleAnnotationClass = this.getServiceModuleAnnotationClass(parent);
        this.propagateOpensToServiceModules(parent, artifactLayer, serviceModuleAnnotationClass);
        MuleServiceClassLoader serviceClassLoader = new MuleServiceClassLoader(artifactId, descriptor, new URL[0], this.findLoader(artifactId, descriptor, artifactLayer, serviceModuleAnnotationClass), lookupPolicy);
        ModuleLayerGraph.setModuleLayerId(artifactLayer, artifactId);
        artifactLayer.parents().stream().filter(parentArtifactLayer -> !parentArtifactLayer.equals(ModuleLayer.boot())).findFirst().ifPresent(parentArtifactLayer -> ModuleLayerGraph.setModuleLayerId(parentArtifactLayer, CONTAINER_LAYER_NAME));
        ModuleLayerGraph graph = new ModuleLayerGraph(artifactLayer);
        serviceClassLoader.setModuleLayerInformationSupplier(graph);
        if (parent instanceof ArtifactClassLoader) {
            ArtifactClassLoader parentArtifactClassLoader = (ArtifactClassLoader)parent;
            parentArtifactClassLoader.setModuleLayerInformationSupplier((ModuleLayerInformationSupplier)graph);
        }
        return serviceClassLoader;
    }

    private Class<? extends Annotation> getServiceModuleAnnotationClass(ClassLoader parent) {
        try {
            return parent.loadClass(ServiceModule.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    private void propagateOpensToServiceModules(ClassLoader parent, ModuleLayer artifactLayer, Class<? extends Annotation> serviceModuleAnnotationClass) {
        artifactLayer.modules().stream().filter(module -> this.isServiceOwnedByMuleRuntime((Module)module, serviceModuleAnnotationClass)).forEach(serviceModule -> this.propagateOpensToService(parent, artifactLayer, serviceModuleAnnotationClass, (Module)serviceModule));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isServiceOwnedByMuleRuntime(Module module, Class<? extends Annotation> serviceModuleAnnotationClass) {
        String serviceModuleName = module.getName();
        if (!module.isAnnotationPresent(serviceModuleAnnotationClass)) return false;
        if (!MULE_SERVICE_MODULE_NAME_PREFIXES.stream().anyMatch(serviceModuleName::startsWith)) return false;
        return true;
    }

    private ClassLoader findLoader(String artifactId, ServiceDescriptor descriptor, ModuleLayer artifactLayer, Class<? extends Annotation> serviceModuleAnnotationClass) {
        return artifactLayer.modules().stream().filter(module -> module.isAnnotationPresent(serviceModuleAnnotationClass)).map(serviceModule -> artifactLayer.findLoader(serviceModule.getName())).findAny().orElseThrow(() -> new NoSuchElementException("No module annotated with 'ServiceModule' for '" + artifactId + "' in " + descriptor.getBundleDescriptor().getArtifactFileName()));
    }

    private void propagateOpensToService(ClassLoader parent, ModuleLayer artifactLayer, Class<? extends Annotation> serviceModuleAnnotationClass, Module serviceModule) {
        try {
            Class<?> requiredOpensAnnotationClass = parent.loadClass(RequiredOpens.class.getName());
            Annotation serviceModuleAnnotation = serviceModule.getAnnotation(serviceModuleAnnotationClass);
            Object[] requiredOpensAll = (Object[])serviceModuleAnnotationClass.getMethod("requiredOpens", new Class[0]).invoke((Object)serviceModuleAnnotation, new Object[0]);
            String serviceModuleName = serviceModule.getName();
            for (Object requiredOpens : requiredOpensAll) {
                String[] stringArray;
                String moduleName = (String)requiredOpensAnnotationClass.getMethod("moduleName", new Class[0]).invoke(requiredOpens, new Object[0]);
                String[] packageNames = (String[])requiredOpensAnnotationClass.getMethod("packageNames", new Class[0]).invoke(requiredOpens, new Object[0]);
                String[] targetModules = (String[])requiredOpensAnnotationClass.getMethod("targetModules", new Class[0]).invoke(requiredOpens, new Object[0]);
                if (targetModules.length == 0) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = serviceModuleName;
                } else {
                    stringArray = targetModules;
                }
                for (String targetModule : stringArray) {
                    JpmsUtils.openToModule((ModuleLayer)artifactLayer, (ModuleLayer)this.parentLayer.orElse(ModuleLayer.boot()), (String)targetModule, (String)moduleName, Arrays.asList(packageNames));
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    @Override
    public ArtifactClassLoader create(String artifactId, ServiceDescriptor descriptor, MuleContainerClassLoaderWrapper containerClassLoader) throws ArtifactClassloaderCreationException {
        return this.create(artifactId, descriptor, containerClassLoader.getContainerClassLoader().getClassLoader(), containerClassLoader.getContainerClassLoaderLookupPolicy());
    }

    @Override
    public void setParentLayerFrom(Class clazz) {
        this.parentLayer = Optional.ofNullable(clazz.getModule().getLayer());
    }

    private static final class MuleServiceClassLoader
    extends MuleArtifactClassLoader {
        private MuleServiceClassLoader(String artifactId, ArtifactDescriptor artifactDescriptor, URL[] urls, ClassLoader parent, ClassLoaderLookupPolicy lookupPolicy) {
            super(artifactId, artifactDescriptor, urls, parent, lookupPolicy);
        }
    }
}

