/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal.util.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.core.api.util.compression.InvalidZipFileException;

public class ZipUtils {
    public static void unzip(File archive, File directory) throws IOException {
        if (directory.exists()) {
            if (!directory.isDirectory()) {
                throw new IOException("Directory is not a directory: " + String.valueOf(directory));
            }
        } else if (!directory.mkdirs()) {
            throw new IOException("Could not create directory: " + String.valueOf(directory));
        }
        try (ZipFile zip = new ZipFile(archive);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipUtils.handleZipEntry(directory, zip, entries.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleZipEntry(File directory, ZipFile zip, ZipEntry entry) throws IOException, FileNotFoundException {
        File file = ZipUtils.verifyZipEntryPath(directory, entry);
        if (entry.isDirectory()) {
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException("Could not create directory: " + String.valueOf(file));
            }
        } else {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Unable to create folders for zip entry: " + entry.getName());
            }
            InputStream is = zip.getInputStream(entry);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            try {
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
                IOUtils.closeQuietly((OutputStream)os);
            }
        }
    }

    private static File verifyZipEntryPath(File targetDirectory, ZipEntry entry) throws IOException {
        Path namePath = Paths.get(entry.getName(), new String[0]);
        if (namePath.getRoot() != null) {
            throw new InvalidZipFileException("Absolute paths are not allowed: " + namePath.toString());
        }
        File targetFile = new File(targetDirectory, entry.getName());
        if (!targetFile.getCanonicalPath().startsWith(targetDirectory.getCanonicalPath())) {
            throw new InvalidZipFileException("External paths are not allowed: " + namePath.toString());
        }
        return targetFile;
    }

    private ZipUtils() {
    }
}

