/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.serialization.dto;

import java.util.Optional;
import java.util.function.UnaryOperator;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.serialization.dto.ComponentMetadataAstDTO;

public class ImportedResourceDTO
implements ImportedResource {
    private final String resourceLocation;
    private final ComponentMetadataAstDTO metadata;
    private final String resolutionFailure;
    private transient PropertiesResolver propertiesResolver;

    public ImportedResourceDTO(String rawResourceLocation, ComponentMetadataAstDTO metadata, String resolutionFailure) {
        this.resourceLocation = rawResourceLocation;
        this.metadata = metadata;
        this.resolutionFailure = resolutionFailure;
    }

    public String getRawResourceLocation() {
        return this.resourceLocation;
    }

    public String getResourceLocation() {
        return this.propertiesResolver.apply(this.resourceLocation);
    }

    public ComponentMetadataAst getMetadata() {
        return this.metadata;
    }

    public Optional<String> getResolutionFailure() {
        return Optional.ofNullable(this.resolutionFailure);
    }

    public void updatePropertiesResolver(UnaryOperator<String> propertiesResolver) {
        this.propertiesResolver.setMappingFunction(propertiesResolver);
    }

    public void setPropertiesResolver(PropertiesResolver propertiesResolver) {
        this.propertiesResolver = propertiesResolver;
    }

    public void enrich() {
        PropertiesResolver propertiesResolver = new PropertiesResolver();
        propertiesResolver.setMappingFunction(UnaryOperator.identity());
        this.setPropertiesResolver(propertiesResolver);
    }
}

