/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.runtime.http.api.sse.server.SseClient;
import org.mule.runtime.http.api.sse.server.SseClientConfig;

public class NettyHttp2RequestReadyCallback
implements HttpResponseReadyCallback {
    private final ChannelHandlerContext ctx;
    private final Http2FrameStream frameStream;

    public NettyHttp2RequestReadyCallback(ChannelHandlerContext ctx, Http2FrameStream stream) {
        this.ctx = ctx;
        this.frameStream = stream;
    }

    public void responseReady(HttpResponse response, ResponseStatusCallback responseStatusCallback) {
        try {
            this.sendResponse(this.ctx, this.frameStream, response, responseStatusCallback);
        }
        catch (Exception e) {
            responseStatusCallback.onErrorSendingResponse((Throwable)e);
        }
    }

    public Writer startResponse(HttpResponse response, final ResponseStatusCallback responseStatusCallback, final Charset encoding) {
        Http2Headers headers = NettyHttp2RequestReadyCallback.extractHeaders(response);
        this.ctx.write((Object)new DefaultHttp2HeadersFrame(headers, false).stream(this.frameStream), this.promiseToCallback(responseStatusCallback, false));
        return new Writer(){

            @Override
            public void write(char[] cbuf, int off, int len) {
                ByteBuf content = NettyHttp2RequestReadyCallback.this.ctx.alloc().buffer();
                content.writeCharSequence((CharSequence)new String(cbuf, off, len), encoding);
                NettyHttp2RequestReadyCallback.this.ctx.write((Object)new DefaultHttp2DataFrame(content, false).stream(NettyHttp2RequestReadyCallback.this.frameStream), NettyHttp2RequestReadyCallback.this.promiseToCallback(responseStatusCallback, false));
            }

            @Override
            public void flush() {
                NettyHttp2RequestReadyCallback.this.ctx.flush();
            }

            @Override
            public void close() {
                NettyHttp2RequestReadyCallback.this.ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(Unpooled.EMPTY_BUFFER, true).stream(NettyHttp2RequestReadyCallback.this.frameStream), NettyHttp2RequestReadyCallback.this.promiseToCallback(responseStatusCallback, true));
            }
        };
    }

    public SseClient startSseResponse(SseClientConfig config) {
        throw new UnsupportedOperationException("SSE is not supported over HTTP/2");
    }

    private void sendResponse(ChannelHandlerContext ctx, Http2FrameStream stream, HttpResponse response, ResponseStatusCallback responseStatusCallback) throws IOException {
        Http2Headers headers = NettyHttp2RequestReadyCallback.extractHeaders(response);
        ctx.write((Object)new DefaultHttp2HeadersFrame(headers, false).stream(stream), this.promiseToCallback(responseStatusCallback, false));
        ByteBuf content = ctx.alloc().buffer();
        InputStream contentAsInputStream = response.getEntity().getContent();
        content.writeBytes(contentAsInputStream, contentAsInputStream.available());
        ctx.writeAndFlush((Object)new DefaultHttp2DataFrame(content, true).stream(stream), this.promiseToCallback(responseStatusCallback, true));
    }

    private static Http2Headers extractHeaders(HttpResponse response) {
        Http2Headers headers = new DefaultHttp2Headers().status((CharSequence)String.valueOf(response.getStatusCode()));
        MultiMap responseHeaders = response.getHeaders();
        for (String key : responseHeaders.keySet()) {
            for (String value : responseHeaders.getAll((Object)key)) {
                headers.add((Object)key, (Object)value);
            }
        }
        return headers;
    }

    private ChannelPromise promiseToCallback(ResponseStatusCallback responseStatusCallback, boolean isLast) {
        ChannelFutureListener futureListener = channelFuture -> {
            if (channelFuture.isSuccess()) {
                if (isLast) {
                    responseStatusCallback.responseSendSuccessfully();
                }
            } else {
                responseStatusCallback.onErrorSendingResponse(channelFuture.cause());
            }
        };
        ChannelPromise channelPromise = this.ctx.newPromise();
        channelPromise.addListener((GenericFutureListener)futureListener);
        return channelPromise;
    }
}

