/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.alert;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.alert.AlertingSupport;
import org.mule.runtime.api.alert.TimedDataAggregation;
import org.mule.runtime.api.alert.TimedDataBuffer;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.time.TimeSupplier;
import org.mule.runtime.core.api.alert.MuleAlertingSupport;
import org.mule.runtime.core.internal.artifact.ArtifactClassLoaderFinder;
import org.mule.runtime.module.log4j.api.MuleAlertingAsyncQueueFullPolicy;

public class DefaultAlertingSupport
implements MuleAlertingSupport,
Initialisable {
    private static final Map<ClassLoader, AlertingSupport> ALERTS_PER_DEPLOYMENT = new WeakHashMap<ClassLoader, AlertingSupport>();
    private TimeSupplier timeSupplier;
    private Map<String, TimedDataBuffer> timedBuffersPerAlert = new ConcurrentHashMap<String, TimedDataBuffer>();
    private Map<String, Map<String, Integer>> contextsPerAlert = new ConcurrentHashMap<String, Map<String, Integer>>();

    public void initialise() throws InitialisationException {
        if (this.isMuleAlertingAsyncQueueFullPolicy()) {
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            ClassLoader regionContextClassLoader = ArtifactClassLoaderFinder.artifactClassLoaderFinder().findRegionContextClassLoader().orElse(tccl);
            ALERTS_PER_DEPLOYMENT.put(regionContextClassLoader, this);
            MuleAlertingAsyncQueueFullPolicy.register((ClassLoader)regionContextClassLoader, regionClassLoader -> ALERTS_PER_DEPLOYMENT.get(regionClassLoader).triggerAlert("ASYNC_LOOGER_RINGBUFFER_FULL"));
        }
    }

    private boolean isMuleAlertingAsyncQueueFullPolicy() {
        ModuleLayer callerLayer = this.getClass().getModule().getLayer();
        if (callerLayer != null) {
            return callerLayer.findModule("org.mule.runtime.logging").isPresent();
        }
        try {
            this.getClass().getClassLoader().loadClass("org.mule.runtime.module.log4j.api.MuleAlertingAsyncQueueFullPolicy");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void triggerAlert(String alertName) {
        this.triggerAlert(alertName, null);
    }

    public <T> void triggerAlert(String alertName, T alertData) {
        TimedDataBuffer buffer = this.timedBuffersPerAlert.computeIfAbsent(Objects.requireNonNull(alertName, "'alertName' cannot be null"), k -> new TimedDataBuffer(this.timeSupplier));
        buffer.put(alertData);
        if (alertData != null) {
            Map contextCounts = this.contextsPerAlert.computeIfAbsent(alertName, k -> new ConcurrentHashMap());
            String normalizedContext = this.normalizeContext(alertData);
            contextCounts.merge(normalizedContext, 1, Integer::sum);
        }
    }

    @Override
    public Map<String, TimedDataAggregation<Integer>> alertsCountAggregation() {
        return this.alertsAggregation(() -> 0, (a, t) -> a + 1);
    }

    @Override
    public Map<String, Map<String, Integer>> getAlertContexts() {
        return Collections.unmodifiableMap(this.contextsPerAlert);
    }

    private String normalizeContext(Object context) {
        String contextStr = context.toString();
        String normalized = contextStr.replaceAll("@[0-9a-fA-F]+", "");
        normalized = normalized.replaceAll("\\s+", " ").trim();
        return normalized;
    }

    @Override
    public <A> Map<String, TimedDataAggregation<A>> alertsAggregation(Supplier<A> baseIntervalAggregationSupplier, BiFunction<A, Object, A> accumulator) {
        Object baseIntevalAggregation = baseIntervalAggregationSupplier.get();
        return this.timedBuffersPerAlert.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((TimedDataBuffer)e.getValue()).aggregate(baseIntevalAggregation, accumulator), (x, y) -> x, TreeMap::new));
    }

    @Inject
    public void setTimeSupplier(TimeSupplier timeSupplier) {
        this.timeSupplier = timeSupplier;
    }

    public static Map<ClassLoader, AlertingSupport> getAlertsPerDeployment() {
        return ALERTS_PER_DEPLOYMENT;
    }
}

