/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.tck;

import java.security.Security;
import java.util.HashSet;
import java.util.Set;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CleanBouncyCastleProvidersExtension
implements BeforeEachCallback,
AfterEachCallback {
    private boolean initialized;
    private Set<String> providers;

    public CleanBouncyCastleProvidersExtension() {
        HashSet<String> providers = new HashSet<String>();
        providers.add("BC");
        providers.add("BCJSSE");
        this.providers = providers;
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        if (this.initialized) {
            throw new IllegalArgumentException("System property was already initialized");
        }
        this.cleanUpProviders();
        this.initialized = true;
    }

    protected void cleanUpProviders() {
        for (String p : this.providers) {
            Security.removeProvider(p);
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        if (!this.initialized) {
            throw new IllegalArgumentException("Bouncy castle provider was not initialized");
        }
        this.cleanUpProviders();
        this.initialized = false;
    }
}

