/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.test.netty.classloader;

import io.qameta.allure.Issue;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.entity.EmptyHttpEntity;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.mule.runtime.http.api.server.async.ResponseStatusCallback;
import org.mule.service.http.netty.impl.client.NettyHttpClient;
import org.mule.service.http.netty.impl.message.content.StringHttpEntity;
import org.mule.service.http.test.common.AbstractHttpTestCase;
import org.mule.service.http.test.netty.utils.NoOpResponseStatusCallback;
import org.mule.service.http.test.netty.utils.ResponseWithoutHeaders;
import org.mule.service.http.test.netty.utils.server.TestHttpServer;
import org.mule.tck.junit4.matcher.Eventually;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.util.CollectableReference;

@Ignore(value="W-17091411")
public class NettyClientResourceReleaserTestCase
extends AbstractHttpTestCase {
    @Rule
    public DynamicPort serverPort = new DynamicPort("serverPort");
    @Rule
    public TestHttpServer testServer = new TestHttpServer("localhost", this.serverPort.getNumber(), false);
    private HttpClient client;

    @Before
    public void setUp() throws Exception {
        this.client = NettyHttpClient.builder().withUsingPersistentConnections(true).build();
        this.client.start();
        this.testServer.addRequestHandler("/hello", (request, responseSender) -> {
            StringHttpEntity helloContent = new StringHttpEntity("Hello from server!");
            responseSender.responseReady((HttpResponse)new ResponseWithoutHeaders(HttpConstants.HttpStatus.OK, (HttpEntity)helloContent), (ResponseStatusCallback)new NoOpResponseStatusCallback());
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Issue(value="W-15631454")
    public void applicationClassLoaderShouldBeCollectedByGcAfterClientIsClosed() throws IOException, InterruptedException, ExecutionException {
        HttpRequest httpRequest = ((HttpRequestBuilder)HttpRequest.builder().uri(String.format("http://localhost:%d/hello", this.serverPort.getNumber())).method("GET").entity((HttpEntity)new EmptyHttpEntity())).build();
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        CollectableReference classLoaderRef = new CollectableReference((Object)new URLClassLoader(new URL[0], parentClassLoader));
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)classLoaderRef.get());
            CompletableFuture response = this.client.sendAsync(httpRequest);
            String responseContent = IOUtils.toString((InputStream)((HttpResponse)response.get()).getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            MatcherAssert.assertThat((Object)responseContent, (Matcher)CoreMatchers.is((Object)"Hello from server!"));
            this.client.stop();
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
        MatcherAssert.assertThat((Object)classLoaderRef, (Matcher)CoreMatchers.is((Matcher)Eventually.eventually((Matcher)CollectableReference.collectedByGc())));
    }
}

