/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.reduced;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.persistence.reduced.ReferenceResolver;

class CatalogTypeCollectorMetadataTypeVisitor
extends MetadataTypeVisitor
implements ReferenceResolver {
    private final LinkedHashMap<String, ObjectType> registeredTypes = new LinkedHashMap();
    private final List<String> index = new ArrayList<String>();

    CatalogTypeCollectorMetadataTypeVisitor() {
    }

    public void visitObject(ObjectType type) {
        String id = this.createIdentifier(type);
        if (this.registeredTypes.containsKey(id)) {
            return;
        }
        this.registeredTypes.put(id, type);
        this.index.add(id);
        type.getOpenRestriction().ifPresent(t -> t.accept((MetadataTypeVisitor)this));
        type.getFields().forEach(field -> field.getValue().accept((MetadataTypeVisitor)this));
    }

    public void visitArrayType(ArrayType arrayType) {
        arrayType.getType().accept((MetadataTypeVisitor)this);
    }

    public void visitFunction(FunctionType functionType) {
        functionType.getParameters().forEach(p -> p.getType().accept((MetadataTypeVisitor)this));
        functionType.getReturnType().ifPresent(rt -> rt.accept((MetadataTypeVisitor)this));
    }

    public void visitIntersection(IntersectionType intersectionType) {
        intersectionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
    }

    public void visitUnion(UnionType unionType) {
        unionType.getTypes().forEach(t -> t.accept((MetadataTypeVisitor)this));
    }

    public Map<String, ObjectType> getCatalog() {
        LinkedHashMap<String, ObjectType> copy = new LinkedHashMap<String, ObjectType>(this.registeredTypes.size());
        ArrayList<String> keys = new ArrayList<String>(this.registeredTypes.keySet());
        for (String key : keys) {
            copy.put(this.referenceIndex(key), this.registeredTypes.get(key));
        }
        return copy;
    }

    private String referenceIndex(String key) {
        return "0x" + Integer.toHexString(this.index.indexOf(key) + 1);
    }

    @Override
    public Optional<String> getIdentifier(ObjectType type) {
        String id = this.createIdentifier(type);
        return this.registeredTypes.containsKey(id) ? Optional.of(this.referenceIndex(id)) : Optional.empty();
    }

    public String createIdentifier(ObjectType type) {
        Optional typeId = MetadataTypeUtils.getTypeId((MetadataType)type);
        return typeId.orElseGet(() -> String.valueOf(System.identityHashCode(type)));
    }
}

