/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import jdk.dynalink.NamedOperation;
import jdk.dynalink.Namespace;
import jdk.dynalink.NamespaceOperation;
import jdk.dynalink.Operation;

class ParsedOperation {
    private final Operation root;
    private final Namespace namespace;
    private final String name;
    private final Operation operation;

    ParsedOperation(Operation rootOp) {
        this.root = rootOp;
        Object nameObj = NamedOperation.getName(rootOp);
        if (nameObj instanceof String) {
            this.name = (String)nameObj;
        } else {
            if (nameObj != null) {
                throw new UnsupportedOperationException(rootOp.toString());
            }
            this.name = "";
        }
        Operation op = NamedOperation.getBaseOperation(rootOp);
        assert (op instanceof NamespaceOperation);
        NamespaceOperation nsOp = (NamespaceOperation)op;
        assert (nsOp.getNamespaceCount() == 1);
        this.namespace = nsOp.getNamespace(0);
        this.operation = nsOp.getBaseOperation();
    }

    boolean isNamespace(Namespace ns) {
        return ns.equals(this.namespace);
    }

    boolean isOperation(Operation op) {
        return op.equals(this.operation);
    }

    boolean isOperation(Operation op1, Operation op2) {
        return op1.equals(this.operation) || op2.equals(this.operation);
    }

    String getName() {
        return this.name;
    }

    public String toString() {
        return this.root.toString();
    }
}

