/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.rx;

import com.google.common.util.concurrent.MoreExecutors;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.mule.runtime.core.internal.util.rx.SynchronousScheduledFuture;

public class ConditionalExecutorServiceDecorator
implements ScheduledExecutorService {
    private final ScheduledExecutorService delegate;
    private final Predicate<ScheduledExecutorService> scheduleOverridePredicate;
    private final ExecutorService directExecutor = MoreExecutors.newDirectExecutorService();

    public ConditionalExecutorServiceDecorator(ScheduledExecutorService executorService, Predicate<ScheduledExecutorService> scheduleOverridePredicate) {
        this.delegate = Objects.requireNonNull(executorService);
        this.scheduleOverridePredicate = scheduleOverridePredicate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
        this.directExecutor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.directExecutor.shutdownNow();
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.directExecutor.isShutdown() && this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.directExecutor.isTerminated() && this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.directExecutor.awaitTermination(0L, unit) && this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.submit(task);
        }
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.submit(task, result);
        }
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.submit(task);
        }
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.invokeAll(tasks);
        }
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.invokeAll(tasks, timeout, unit);
        }
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.invokeAny(tasks);
        }
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.directExecutor.invokeAny(tasks, timeout, unit);
        }
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            this.directExecutor.execute(command);
        } else {
            this.delegate.execute(command);
        }
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.synchronousSchedule(() -> {
                command.run();
                return null;
            }, delay, unit);
        }
        return this.delegate.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            return this.synchronousSchedule(callable, delay, unit);
        }
        return this.delegate.schedule(callable, delay, unit);
    }

    private <V> ScheduledFuture<V> synchronousSchedule(Callable<V> callable, long delay, TimeUnit unit) {
        try {
            Thread.sleep(unit.toMillis(delay));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return new SynchronousScheduledFuture(true);
        }
        try {
            return new SynchronousScheduledFuture<V>(callable.call());
        }
        catch (Exception e) {
            return new SynchronousScheduledFuture(e);
        }
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            throw new RejectedExecutionException("Cannot schedule recurrent tasks in a transactional context.");
        }
        return this.delegate.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        if (this.scheduleOverridePredicate.test(this.delegate)) {
            throw new RejectedExecutionException("Cannot schedule recurrent tasks in a transactional context.");
        }
        return this.delegate.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }
}

